/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.cli;

import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommandHandler;
import org.kohsuke.args4j.spi.SubCommands;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.cli.commands.GetCommand;
import org.opennms.features.scv.cli.commands.ListCommand;
import org.opennms.features.scv.cli.commands.SetCommand;
import org.opennms.features.scv.jceks.JCEKSSecureCredentialsVault;

public class ScvCli {
    private static final String DEFAULT_PASSWORD_PROPERTY = "org.opennms.features.scv.cli.password";
    @Argument(required=true, index=0, metaVar="ACTION", handler=SubCommandHandler.class)
    @SubCommands(value={@SubCommand(name="list", impl=ListCommand.class), @SubCommand(name="set", impl=SetCommand.class), @SubCommand(name="get", impl=GetCommand.class)})
    private Function<ScvCli, Integer> command;
    @Option(name="--keystore", aliases={"-k"}, required=false, metaVar="KEYSTORE")
    private String keystore = "scv.jce";
    @Option(name="--password", aliases={"-p"}, required=false, metaVar="PASSWORD")
    private String password = ScvCli.lookupDefaultPassword();
    private SecureCredentialsVault secureCredentialsVault;

    private ScvCli() {
    }

    public SecureCredentialsVault getSecureCredentialsVault() {
        if (this.secureCredentialsVault == null) {
            this.secureCredentialsVault = new JCEKSSecureCredentialsVault(this.keystore, this.password);
        }
        return this.secureCredentialsVault;
    }

    private static String lookupDefaultPassword() {
        Properties properties = new Properties();
        try {
            properties.load(ScvCli.class.getResourceAsStream("/scvcli.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty(DEFAULT_PASSWORD_PROPERTY);
    }

    public static void main(String[] args) {
        ScvCli scvCli = new ScvCli();
        scvCli.parseArguments(args);
        try {
            System.exit(scvCli.command.apply(scvCli));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void parseArguments(String[] args) {
        CmdLineParser cmdLineParser = new CmdLineParser((Object)this);
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println("Error: " + e.getMessage() + "\n");
            System.err.println("Usage: scvcli [--keystore KEYSTORE] [--password PASSWORD] set ALIAS USERNAME PASSWORD [--attribute key=value]...");
            System.err.println("       scvcli [--keystore KEYSTORE] [--password PASSWORD] get ALIAS");
            System.err.println("       scvcli [--keystore KEYSTORE] [--password PASSWORD] list");
            System.exit(1);
        }
    }
}

