/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.cli.commands;

import java.util.function.Function;
import org.kohsuke.args4j.Argument;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.cli.ScvCli;

public class GetCommand
implements Function<ScvCli, Integer> {
    @Argument(required=true, index=0, metaVar="alias", usage="the alias for this entry")
    private String alias = null;

    @Override
    public Integer apply(ScvCli scvCli) {
        Credentials credentials = scvCli.getSecureCredentialsVault().getCredentials(this.alias);
        if (credentials == null) {
            System.err.println("No credentials found for alias '" + this.alias + "'.");
            return 1;
        }
        System.out.printf("Credentials for %s:\n", this.alias);
        System.out.printf("\tUsername: %s\n", credentials.getUsername());
        System.out.printf("\tPassword: *********\n", new Object[0]);
        for (String attributeKey : credentials.getAttributeKeys()) {
            System.out.printf("\t%s: %s\n", attributeKey, credentials.getAttribute(attributeKey));
        }
        return 0;
    }
}

