package org.opennms.web.rest.mapper.v2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsReductionKeyMemo;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.model.v2.AlarmDTO;
import org.opennms.web.rest.model.v2.AlarmSummaryDTO;
import org.opennms.web.rest.model.v2.EventParameterDTO;
import org.opennms.web.rest.model.v2.MemoDTO;
import org.opennms.web.rest.model.v2.ReductionKeyMemoDTO;
import org.opennms.web.rest.model.v2.ServiceTypeDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-10-20T05:58:26-0400",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class AlarmMapperImpl extends AlarmMapper {

    @Autowired
    private EventMapper eventMapper;

    @Override
    public AlarmDTO alarmToAlarmDTO(OnmsAlarm alarm) {
        if ( alarm == null ) {
            return null;
        }

        AlarmDTO alarmDTO = new AlarmDTO();

        alarmDTO.setSeverity( alarm.getSeverityLabel() );
        alarmDTO.setAckTime( alarm.getAlarmAckTime() );
        alarmDTO.setLogMessage( alarm.getLogMsg() );
        alarmDTO.setOperatorInstructions( alarm.getOperInstruct() );
        alarmDTO.setIpAddress( alarm.getIpAddr() );
        alarmDTO.setCount( alarm.getCounter() );
        alarmDTO.setSuppressedBy( alarm.getSuppressedUser() );
        alarmDTO.setTroubleTicket( alarm.getTTicketId() );
        alarmDTO.setType( alarm.getAlarmType() );
        alarmDTO.setAckUser( alarm.getAlarmAckUser() );
        alarmDTO.setTroubleTicketState( mapTicketStateToInt( alarm.getTTicketState() ) );
        alarmDTO.setLocation( alarmDistPollerLocation( alarm ) );
        alarmDTO.setId( alarm.getId() );
        alarmDTO.setUei( alarm.getUei() );
        alarmDTO.setNodeId( alarm.getNodeId() );
        alarmDTO.setNodeLabel( alarm.getNodeLabel() );
        alarmDTO.setServiceType( eventMapper.serviceTypeToServiceTypeDTO( alarm.getServiceType() ) );
        alarmDTO.setReductionKey( alarm.getReductionKey() );
        alarmDTO.setFirstEventTime( alarm.getFirstEventTime() );
        alarmDTO.setDescription( alarm.getDescription() );
        alarmDTO.setMouseOverText( alarm.getMouseOverText() );
        alarmDTO.setSuppressedUntil( alarm.getSuppressedUntil() );
        alarmDTO.setSuppressedTime( alarm.getSuppressedTime() );
        alarmDTO.setClearKey( alarm.getClearKey() );
        alarmDTO.setLastEvent( eventMapper.eventToEventDTO( alarm.getLastEvent() ) );
        alarmDTO.setLastEventTime( alarm.getLastEventTime() );
        alarmDTO.setApplicationDN( alarm.getApplicationDN() );
        alarmDTO.setManagedObjectInstance( alarm.getManagedObjectInstance() );
        alarmDTO.setManagedObjectType( alarm.getManagedObjectType() );
        alarmDTO.setOssPrimaryKey( alarm.getOssPrimaryKey() );
        alarmDTO.setX733AlarmType( alarm.getX733AlarmType() );
        alarmDTO.setX733ProbableCause( alarm.getX733ProbableCause() );
        alarmDTO.setQosAlarmState( alarm.getQosAlarmState() );
        alarmDTO.setFirstAutomationTime( alarm.getFirstAutomationTime() );
        alarmDTO.setLastAutomationTime( alarm.getLastAutomationTime() );
        alarmDTO.setIfIndex( alarm.getIfIndex() );
        alarmDTO.setReductionKeyMemo( onmsReductionKeyMemoToReductionKeyMemoDTO( alarm.getReductionKeyMemo() ) );
        alarmDTO.setStickyMemo( onmsMemoToMemoDTO( alarm.getStickyMemo() ) );
        alarmDTO.setAffectedNodeCount( alarm.getAffectedNodeCount() );

        fillAlarm( alarm, alarmDTO );

        return alarmDTO;
    }

    @Override
    public OnmsAlarm alarmDTOToAlarm(AlarmDTO alarm) {
        if ( alarm == null ) {
            return null;
        }

        OnmsAlarm onmsAlarm = new OnmsAlarm();

        onmsAlarm.setDistPoller( alarmDTOToOnmsMonitoringSystem( alarm ) );
        onmsAlarm.setAlarmType( alarm.getType() );
        onmsAlarm.setSeverityLabel( alarm.getSeverity() );
        onmsAlarm.setTTicketId( alarm.getTroubleTicket() );
        onmsAlarm.setOperInstruct( alarm.getOperatorInstructions() );
        onmsAlarm.setTTicketState( mapIntToTicketState( alarm.getTroubleTicketState() ) );
        onmsAlarm.setLogMsg( alarm.getLogMessage() );
        onmsAlarm.setSuppressedUser( alarm.getSuppressedBy() );
        onmsAlarm.setAlarmAckUser( alarm.getAckUser() );
        onmsAlarm.setCounter( alarm.getCount() );
        onmsAlarm.setAlarmAckTime( alarm.getAckTime() );
        onmsAlarm.setIpAddr( alarm.getIpAddress() );
        onmsAlarm.setId( alarm.getId() );
        onmsAlarm.setUei( alarm.getUei() );
        onmsAlarm.setServiceType( serviceTypeDTOToOnmsServiceType( alarm.getServiceType() ) );
        onmsAlarm.setReductionKey( alarm.getReductionKey() );
        if ( alarm.getSeverity() != null ) {
            onmsAlarm.setSeverity( Enum.valueOf( OnmsSeverity.class, alarm.getSeverity() ) );
        }
        onmsAlarm.setFirstEventTime( alarm.getFirstEventTime() );
        onmsAlarm.setDescription( alarm.getDescription() );
        onmsAlarm.setMouseOverText( alarm.getMouseOverText() );
        onmsAlarm.setSuppressedUntil( alarm.getSuppressedUntil() );
        onmsAlarm.setSuppressedTime( alarm.getSuppressedTime() );
        onmsAlarm.setClearKey( alarm.getClearKey() );
        onmsAlarm.setLastEvent( eventMapper.eventDTOToEvent( alarm.getLastEvent() ) );
        onmsAlarm.setLastEventTime( alarm.getLastEventTime() );
        onmsAlarm.setApplicationDN( alarm.getApplicationDN() );
        onmsAlarm.setManagedObjectInstance( alarm.getManagedObjectInstance() );
        onmsAlarm.setManagedObjectType( alarm.getManagedObjectType() );
        onmsAlarm.setOssPrimaryKey( alarm.getOssPrimaryKey() );
        onmsAlarm.setX733AlarmType( alarm.getX733AlarmType() );
        if ( alarm.getX733ProbableCause() != null ) {
            onmsAlarm.setX733ProbableCause( alarm.getX733ProbableCause() );
        }
        onmsAlarm.setQosAlarmState( alarm.getQosAlarmState() );
        onmsAlarm.setFirstAutomationTime( alarm.getFirstAutomationTime() );
        onmsAlarm.setLastAutomationTime( alarm.getLastAutomationTime() );
        onmsAlarm.setIfIndex( alarm.getIfIndex() );
        onmsAlarm.setReductionKeyMemo( reductionKeyMemoDTOToOnmsReductionKeyMemo( alarm.getReductionKeyMemo() ) );
        onmsAlarm.setStickyMemo( memoDTOToOnmsMemo( alarm.getStickyMemo() ) );
        onmsAlarm.setRelatedAlarms( alarmSummaryDTOListToOnmsAlarmSet( alarm.getRelatedAlarms() ) );

        return onmsAlarm;
    }

    @Override
    public EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter eventParameter) {
        if ( eventParameter == null ) {
            return null;
        }

        EventParameterDTO eventParameterDTO = new EventParameterDTO();

        eventParameterDTO.setName( eventParameter.getName() );
        eventParameterDTO.setValue( eventParameter.getValue() );
        eventParameterDTO.setType( eventParameter.getType() );

        return eventParameterDTO;
    }

    @Override
    public AlarmSummaryDTO alarmToAlarmSummaryDTO(OnmsAlarm alarm) {
        if ( alarm == null ) {
            return null;
        }

        AlarmSummaryDTO alarmSummaryDTO = new AlarmSummaryDTO();

        if ( alarm.getSeverity() != null ) {
            alarmSummaryDTO.setSeverity( alarm.getSeverity().name() );
        }
        alarmSummaryDTO.setLogMessage( alarm.getLogMsg() );
        alarmSummaryDTO.setUei( alarmLastEventEventUei( alarm ) );
        alarmSummaryDTO.setDescription( alarm.getDescription() );
        alarmSummaryDTO.setId( alarm.getId() );
        alarmSummaryDTO.setType( ackTypeToInteger( alarm.getType() ) );
        alarmSummaryDTO.setReductionKey( alarm.getReductionKey() );
        alarmSummaryDTO.setNodeLabel( alarm.getNodeLabel() );

        mapEventLabel( alarmSummaryDTO );

        return alarmSummaryDTO;
    }

    private String alarmDistPollerLocation(OnmsAlarm onmsAlarm) {
        if ( onmsAlarm == null ) {
            return null;
        }
        OnmsMonitoringSystem distPoller = onmsAlarm.getDistPoller();
        if ( distPoller == null ) {
            return null;
        }
        String location = distPoller.getLocation();
        if ( location == null ) {
            return null;
        }
        return location;
    }

    protected ReductionKeyMemoDTO onmsReductionKeyMemoToReductionKeyMemoDTO(OnmsReductionKeyMemo onmsReductionKeyMemo) {
        if ( onmsReductionKeyMemo == null ) {
            return null;
        }

        ReductionKeyMemoDTO reductionKeyMemoDTO = new ReductionKeyMemoDTO();

        reductionKeyMemoDTO.setId( onmsReductionKeyMemo.getId() );
        reductionKeyMemoDTO.setBody( onmsReductionKeyMemo.getBody() );
        reductionKeyMemoDTO.setAuthor( onmsReductionKeyMemo.getAuthor() );
        reductionKeyMemoDTO.setUpdated( onmsReductionKeyMemo.getUpdated() );
        reductionKeyMemoDTO.setCreated( onmsReductionKeyMemo.getCreated() );
        reductionKeyMemoDTO.setReductionKey( onmsReductionKeyMemo.getReductionKey() );

        return reductionKeyMemoDTO;
    }

    protected MemoDTO onmsMemoToMemoDTO(OnmsMemo onmsMemo) {
        if ( onmsMemo == null ) {
            return null;
        }

        MemoDTO memoDTO = new MemoDTO();

        memoDTO.setId( onmsMemo.getId() );
        memoDTO.setBody( onmsMemo.getBody() );
        memoDTO.setAuthor( onmsMemo.getAuthor() );
        memoDTO.setUpdated( onmsMemo.getUpdated() );
        memoDTO.setCreated( onmsMemo.getCreated() );

        return memoDTO;
    }

    protected OnmsMonitoringSystem alarmDTOToOnmsMonitoringSystem(AlarmDTO alarmDTO) {
        if ( alarmDTO == null ) {
            return null;
        }

        OnmsMonitoringSystem onmsMonitoringSystem = new OnmsMonitoringSystem();

        onmsMonitoringSystem.setLocation( alarmDTO.getLocation() );

        return onmsMonitoringSystem;
    }

    protected OnmsServiceType serviceTypeDTOToOnmsServiceType(ServiceTypeDTO serviceTypeDTO) {
        if ( serviceTypeDTO == null ) {
            return null;
        }

        OnmsServiceType onmsServiceType = new OnmsServiceType();

        onmsServiceType.setId( serviceTypeDTO.getId() );
        onmsServiceType.setName( serviceTypeDTO.getName() );

        return onmsServiceType;
    }

    protected OnmsReductionKeyMemo reductionKeyMemoDTOToOnmsReductionKeyMemo(ReductionKeyMemoDTO reductionKeyMemoDTO) {
        if ( reductionKeyMemoDTO == null ) {
            return null;
        }

        OnmsReductionKeyMemo onmsReductionKeyMemo = new OnmsReductionKeyMemo();

        onmsReductionKeyMemo.setBody( reductionKeyMemoDTO.getBody() );
        onmsReductionKeyMemo.setId( reductionKeyMemoDTO.getId() );
        onmsReductionKeyMemo.setCreated( reductionKeyMemoDTO.getCreated() );
        onmsReductionKeyMemo.setUpdated( reductionKeyMemoDTO.getUpdated() );
        onmsReductionKeyMemo.setAuthor( reductionKeyMemoDTO.getAuthor() );
        onmsReductionKeyMemo.setReductionKey( reductionKeyMemoDTO.getReductionKey() );

        return onmsReductionKeyMemo;
    }

    protected OnmsMemo memoDTOToOnmsMemo(MemoDTO memoDTO) {
        if ( memoDTO == null ) {
            return null;
        }

        OnmsMemo onmsMemo = new OnmsMemo();

        onmsMemo.setBody( memoDTO.getBody() );
        onmsMemo.setId( memoDTO.getId() );
        onmsMemo.setCreated( memoDTO.getCreated() );
        onmsMemo.setUpdated( memoDTO.getUpdated() );
        onmsMemo.setAuthor( memoDTO.getAuthor() );

        return onmsMemo;
    }

    protected OnmsAlarm alarmSummaryDTOToOnmsAlarm(AlarmSummaryDTO alarmSummaryDTO) {
        if ( alarmSummaryDTO == null ) {
            return null;
        }

        OnmsAlarm onmsAlarm = new OnmsAlarm();

        onmsAlarm.setId( alarmSummaryDTO.getId() );
        onmsAlarm.setUei( alarmSummaryDTO.getUei() );
        onmsAlarm.setReductionKey( alarmSummaryDTO.getReductionKey() );
        if ( alarmSummaryDTO.getSeverity() != null ) {
            onmsAlarm.setSeverity( Enum.valueOf( OnmsSeverity.class, alarmSummaryDTO.getSeverity() ) );
        }
        onmsAlarm.setDescription( alarmSummaryDTO.getDescription() );

        return onmsAlarm;
    }

    protected Set<OnmsAlarm> alarmSummaryDTOListToOnmsAlarmSet(List<AlarmSummaryDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<OnmsAlarm> set = new HashSet<OnmsAlarm>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( AlarmSummaryDTO alarmSummaryDTO : list ) {
            set.add( alarmSummaryDTOToOnmsAlarm( alarmSummaryDTO ) );
        }

        return set;
    }

    private String alarmLastEventEventUei(OnmsAlarm onmsAlarm) {
        if ( onmsAlarm == null ) {
            return null;
        }
        OnmsEvent lastEvent = onmsAlarm.getLastEvent();
        if ( lastEvent == null ) {
            return null;
        }
        String eventUei = lastEvent.getEventUei();
        if ( eventUei == null ) {
            return null;
        }
        return eventUei;
    }
}
