/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.mapper.v2;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.Situation;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.mapper.v2.EventMapper;
import org.opennms.web.rest.model.v2.AlarmDTO;
import org.opennms.web.rest.model.v2.AlarmSummaryDTO;
import org.opennms.web.rest.model.v2.EventParameterDTO;

@Mapper(componentModel="spring", uses={EventMapper.class})
public abstract class AlarmMapper {
    private String ticketUrlTemplate = System.getProperty("opennms.alarmTroubleTicketLinkTemplate");

    @Mappings(value={@Mapping(source="distPoller.location", target="location"), @Mapping(source="ipAddr", target="ipAddress"), @Mapping(source="alarmType", target="type"), @Mapping(ignore=true, target="relatedAlarms"), @Mapping(source="counter", target="count"), @Mapping(source="severityLabel", target="severity"), @Mapping(source="logMsg", target="logMessage"), @Mapping(source="operInstruct", target="operatorInstructions"), @Mapping(source="TTicketId", target="troubleTicket"), @Mapping(source="TTicketState", target="troubleTicketState"), @Mapping(source="alarmAckUser", target="ackUser"), @Mapping(source="alarmAckTime", target="ackTime"), @Mapping(source="suppressedUser", target="suppressedBy")})
    public abstract AlarmDTO alarmToAlarmDTO(OnmsAlarm var1);

    @InheritInverseConfiguration
    public abstract OnmsAlarm alarmDTOToAlarm(AlarmDTO var1);

    public Integer ackTypeToInteger(AckType ack) {
        return ack.getId();
    }

    @AfterMapping
    protected void fillAlarm(OnmsAlarm alarm, @MappingTarget AlarmDTO alarmDTO) {
        List eventParms = alarm.getEventParameters();
        if (eventParms != null) {
            alarmDTO.setParameters(eventParms.stream().map(this::eventParameterToEventParameterDTO).collect(Collectors.toList()));
        }
        if (alarm.getTTicketId() != null && !alarm.getTTicketId().isEmpty() && this.ticketUrlTemplate != null) {
            alarmDTO.setTroubleTicketLink(this.getTicketUrl(alarm.getTTicketId()));
        }
        if (alarm instanceof Situation) {
            alarmDTO.setRelatedAlarms(((Situation)alarm).getAlarms().stream().map(a -> this.alarmToAlarmSummaryDTO((OnmsAlarm)a)).sorted(Comparator.comparing(AlarmSummaryDTO::getId)).collect(Collectors.toList()));
        }
    }

    protected Integer mapTicketStateToInt(TroubleTicketState state) {
        if (state == null) {
            return null;
        }
        return state.getValue();
    }

    protected TroubleTicketState mapIntToTicketState(Integer value) {
        return Arrays.stream(TroubleTicketState.values()).filter(s -> Objects.equals(value, s.getValue())).findFirst().orElse(null);
    }

    public abstract EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter var1);

    public abstract AlarmSummaryDTO alarmToAlarmSummaryDTO(OnmsAlarm var1);

    public void setTicketUrlTemplate(String ticketUrlTemplate) {
        this.ticketUrlTemplate = ticketUrlTemplate;
    }

    private String getTicketUrl(String ticketId) {
        Objects.requireNonNull(this.ticketUrlTemplate);
        Objects.requireNonNull(ticketId);
        return this.ticketUrlTemplate.replaceAll("\\$\\{id\\}", ticketId);
    }
}

