package org.opennms.web.rest.mapper.v2;

import javax.annotation.Generated;

import org.opennms.netmgt.model.OnmsEvent;

import org.opennms.netmgt.model.OnmsEventParameter;

import org.opennms.netmgt.model.OnmsMonitoringSystem;

import org.opennms.netmgt.model.OnmsServiceType;

import org.opennms.web.rest.model.v2.EventDTO;

import org.opennms.web.rest.model.v2.EventParameterDTO;

import org.opennms.web.rest.model.v2.ServiceTypeDTO;

import org.springframework.stereotype.Component;

@Generated(

    value = "org.mapstruct.ap.MappingProcessor",

    date = "2017-10-10T22:09:17-0400",

    comments = "version: 1.2.0.CR1, compiler: javac, environment: Java 1.8.0_144 (Oracle Corporation)"

)

@Component

public class EventMapperImpl extends EventMapper {

    @Override

    public EventDTO eventToEventDTO(OnmsEvent event) {

        if ( event == null ) {

            return null;
        }

        EventDTO eventDTO = new EventDTO();

        eventDTO.setAckTime( event.getEventAckTime() );

        eventDTO.setOperatorAction( event.getEventOperAction() );

        eventDTO.setLog( event.getEventLog() );

        eventDTO.setLogMessage( event.getEventLogMsg() );

        eventDTO.setDescription( event.getEventDescr() );

        eventDTO.setSource( event.getEventSource() );

        eventDTO.setSnmp( event.getEventSnmp() );

        eventDTO.setAckUser( event.getEventAckUser() );

        eventDTO.setAutoAction( event.getEventAutoAction() );

        eventDTO.setNotification( event.getEventNotification() );

        eventDTO.setMouseOverText( event.getEventMouseOverText() );

        eventDTO.setSuppressedCount( event.getEventSuppressedCount() );

        eventDTO.setUei( event.getEventUei() );

        eventDTO.setHost( event.getEventHost() );

        eventDTO.setSeverity( event.getSeverityLabel() );

        eventDTO.setPathOutage( event.getEventPathOutage() );

        eventDTO.setSnmpHost( event.getEventSnmpHost() );

        eventDTO.setOperatorInstructions( event.getEventOperInstruct() );

        eventDTO.setOperationActionMenuText( event.getEventOperActionMenuText() );

        eventDTO.setDisplay( event.getEventDisplay() );

        eventDTO.setIpAddress( event.getIpAddr() );

        eventDTO.setLogGroup( event.getEventLogGroup() );

        eventDTO.setTroubleTicket( event.getEventTTicket() );

        eventDTO.setCorrelation( event.getEventCorrelation() );

        eventDTO.setCreateTime( event.getEventCreateTime() );

        eventDTO.setTroubleTicketState( event.getEventTTicketState() );

        String location = eventDistPollerLocation( event );

        if ( location != null ) {

            eventDTO.setLocation( location );
        }

        eventDTO.setTime( event.getEventTime() );

        eventDTO.setId( event.getId() );

        eventDTO.setServiceType( serviceTypeToServiceTypeDTO( event.getServiceType() ) );

        eventDTO.setNodeId( event.getNodeId() );

        eventDTO.setNodeLabel( event.getNodeLabel() );

        eventDTO.setIfIndex( event.getIfIndex() );

        fillEvent( event, eventDTO );

        return eventDTO;
    }

    @Override

    public OnmsEvent eventDTOToEvent(EventDTO event) {

        if ( event == null ) {

            return null;
        }

        OnmsEvent onmsEvent = new OnmsEvent();

        onmsEvent.setDistPoller( eventDTOToOnmsMonitoringSystem( event ) );

        onmsEvent.setEventCreateTime( event.getCreateTime() );

        onmsEvent.setEventSuppressedCount( event.getSuppressedCount() );

        onmsEvent.setEventSource( event.getSource() );

        onmsEvent.setEventUei( event.getUei() );

        onmsEvent.setIpAddr( event.getIpAddress() );

        onmsEvent.setEventDisplay( event.getDisplay() );

        onmsEvent.setEventCorrelation( event.getCorrelation() );

        onmsEvent.setEventTime( event.getTime() );

        onmsEvent.setEventLog( event.getLog() );

        onmsEvent.setEventSnmpHost( event.getSnmpHost() );

        onmsEvent.setEventTTicketState( event.getTroubleTicketState() );

        onmsEvent.setEventOperAction( event.getOperatorAction() );

        onmsEvent.setEventAckUser( event.getAckUser() );

        onmsEvent.setSeverityLabel( event.getSeverity() );

        onmsEvent.setEventOperActionMenuText( event.getOperationActionMenuText() );

        onmsEvent.setEventTTicket( event.getTroubleTicket() );

        onmsEvent.setEventAckTime( event.getAckTime() );

        onmsEvent.setEventSnmp( event.getSnmp() );

        onmsEvent.setEventNotification( event.getNotification() );

        onmsEvent.setEventMouseOverText( event.getMouseOverText() );

        onmsEvent.setEventPathOutage( event.getPathOutage() );

        onmsEvent.setEventOperInstruct( event.getOperatorInstructions() );

        onmsEvent.setEventDescr( event.getDescription() );

        onmsEvent.setEventAutoAction( event.getAutoAction() );

        onmsEvent.setEventLogMsg( event.getLogMessage() );

        onmsEvent.setEventLogGroup( event.getLogGroup() );

        onmsEvent.setEventHost( event.getHost() );

        onmsEvent.setId( event.getId() );

        onmsEvent.setServiceType( serviceTypeDTOToOnmsServiceType( event.getServiceType() ) );

        onmsEvent.setIfIndex( event.getIfIndex() );

        return onmsEvent;
    }

    @Override

    public ServiceTypeDTO serviceTypeToServiceTypeDTO(OnmsServiceType serviceType) {

        if ( serviceType == null ) {

            return null;
        }

        ServiceTypeDTO serviceTypeDTO = new ServiceTypeDTO();

        serviceTypeDTO.setId( serviceType.getId() );

        serviceTypeDTO.setName( serviceType.getName() );

        return serviceTypeDTO;
    }

    @Override

    public EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter eventParameter) {

        if ( eventParameter == null ) {

            return null;
        }

        EventParameterDTO eventParameterDTO = new EventParameterDTO();

        eventParameterDTO.setName( eventParameter.getName() );

        eventParameterDTO.setValue( eventParameter.getValue() );

        eventParameterDTO.setType( eventParameter.getType() );

        return eventParameterDTO;
    }

    private String eventDistPollerLocation(OnmsEvent onmsEvent) {

        if ( onmsEvent == null ) {

            return null;
        }

        OnmsMonitoringSystem distPoller = onmsEvent.getDistPoller();

        if ( distPoller == null ) {

            return null;
        }

        String location = distPoller.getLocation();

        if ( location == null ) {

            return null;
        }

        return location;
    }

    protected OnmsMonitoringSystem eventDTOToOnmsMonitoringSystem(EventDTO eventDTO) {

        if ( eventDTO == null ) {

            return null;
        }

        OnmsMonitoringSystem onmsMonitoringSystem = new OnmsMonitoringSystem();

        onmsMonitoringSystem.setLocation( eventDTO.getLocation() );

        return onmsMonitoringSystem;
    }

    protected OnmsServiceType serviceTypeDTOToOnmsServiceType(ServiceTypeDTO serviceTypeDTO) {

        if ( serviceTypeDTO == null ) {

            return null;
        }

        OnmsServiceType onmsServiceType = new OnmsServiceType();

        onmsServiceType.setId( serviceTypeDTO.getId() );

        onmsServiceType.setName( serviceTypeDTO.getName() );

        return onmsServiceType;
    }
}

