/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.mapper.v2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.mapper.v2.EventMapper;
import org.opennms.web.rest.model.v2.AlarmDTO;
import org.opennms.web.rest.model.v2.EventParameterDTO;

@Mapper(componentModel="spring", uses={EventMapper.class})
public abstract class AlarmMapper {
    @Mappings(value={@Mapping(source="distPoller.location", target="location"), @Mapping(source="ipAddr", target="ipAddress"), @Mapping(source="alarmType", target="type"), @Mapping(source="counter", target="count"), @Mapping(source="severityLabel", target="severity"), @Mapping(source="logMsg", target="logMessage"), @Mapping(source="operInstruct", target="operatorInstructions"), @Mapping(source="TTicketId", target="troubleTicket"), @Mapping(source="TTicketState", target="troubleTicketState"), @Mapping(source="alarmAckUser", target="ackUser"), @Mapping(source="alarmAckTime", target="ackTime"), @Mapping(source="suppressedUser", target="suppressedBy")})
    public abstract AlarmDTO alarmToAlarmDTO(OnmsAlarm var1);

    @InheritInverseConfiguration
    public abstract OnmsAlarm alarmDTOToAlarm(AlarmDTO var1);

    @AfterMapping
    protected void fillAlarm(OnmsAlarm alarm, @MappingTarget AlarmDTO alarmDTO) {
        List eventParms = alarm.getEventParameters();
        if (eventParms != null) {
            alarmDTO.setParameters(eventParms.stream().map(this::eventParameterToEventParameterDTO).collect(Collectors.toList()));
        }
    }

    protected Integer mapTicketStateToInt(TroubleTicketState state) {
        if (state == null) {
            return null;
        }
        return state.getValue();
    }

    protected TroubleTicketState mapIntToTicketState(Integer value) {
        return Arrays.stream(TroubleTicketState.values()).filter(s -> Objects.equals(value, s.getValue())).findFirst().orElse(null);
    }

    public abstract EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter var1);
}

