/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.resourcemgnt.commands;

import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.cxf.common.util.Base64Utility;
import org.opennms.features.resourcemgnt.ResourceCli;
import org.opennms.features.resourcemgnt.commands.Command;

public abstract class AbstractCommand
implements Command {
    protected Invocation.Builder connect(ResourceCli resourceCli, String resource) {
        Client client = ClientBuilder.newClient();
        StringBuilder url = new StringBuilder();
        url.append(resourceCli.getBaseUrl());
        url.append("/rest/resources");
        if (!Strings.isNullOrEmpty((String)resource)) {
            url.append("/");
            url.append(UrlEscapers.urlPathSegmentEscaper().escape(resource));
        }
        WebTarget target = client.target(url.toString());
        String authorizationHeader = "Basic " + Base64Utility.encode((byte[])(resourceCli.getUsername() + ":" + resourceCli.getPassword()).getBytes());
        return target.request().header("Authorization", (Object)authorizationHeader);
    }

    protected Invocation.Builder connect(ResourceCli resourceCli) {
        return this.connect(resourceCli, null);
    }
}

