/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.resourcemgnt.commands;

import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.opennms.features.resourcemgnt.ResourceCli;
import org.opennms.features.resourcemgnt.commands.AbstractCommand;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.web.rest.v1.ResourceDTO;

public class ShowCommand
extends AbstractCommand {
    @Argument(required=true, metaVar="resource", usage="the resource to show")
    private String resource = "";

    @Override
    public void execute(ResourceCli resourceCli) throws Exception {
        ResourceDTO resource = (ResourceDTO)this.connect(resourceCli, this.resource).header("Accept", (Object)"application/xml").get(ResourceDTO.class);
        System.out.println("ID:         " + resource.getId());
        System.out.println("Name:       " + resource.getName());
        System.out.println("Label:      " + resource.getLabel());
        System.out.println("Type:       " + resource.getTypeLabel());
        System.out.println("Link:       " + resource.getLink());
        System.out.println("Parent ID:  " + resource.getParentId());
        System.out.println("Children:");
        if (resource.getChildren() != null) {
            for (ResourceDTO resourceDTO : resource.getChildren().getObjects()) {
                System.out.println("  " + resourceDTO.getId());
            }
        }
        System.out.println("Attributes:");
        System.out.println("  External:");
        for (Map.Entry entry : resource.getExternalValueAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + (String)entry.getValue() + "'");
        }
        System.out.println("  Graphs:");
        for (Map.Entry entry : resource.getRrdGraphAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + ((RrdGraphAttribute)entry.getValue()).getRrdFile() + "'");
        }
        System.out.println("  Strings:");
        for (Map.Entry entry : resource.getStringPropertyAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + (String)entry.getValue() + "'");
        }
    }
}

