/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filters.shell;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.transaction.support.TransactionOperations;

@Command(scope="filters", name="filter", description="Enumerates nodes/interfaces that match a give filter")
@Service
public class FilterCommand
implements Action {
    @Reference
    private FilterDao filterDao;
    @Reference
    private NodeDao nodeDao;
    @Reference
    private TransactionOperations transactionOperations;
    @Argument(description="A filter Rule", required=true, multiValued=false)
    private String filterRule;

    public Object execute() throws Exception {
        this.transactionOperations.execute(status -> {
            boolean matching = false;
            Map nodeMap = null;
            List matchingInetAddressList = null;
            try {
                matching = this.filterDao.isRuleMatching(this.filterRule);
                if (matching) {
                    nodeMap = this.filterDao.getNodeMap(this.filterRule);
                    matchingInetAddressList = this.filterDao.getActiveIPAddressList(this.filterRule);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!matching) {
                System.out.printf("No matching nodes/interfaces for this rule.\n", new Object[0]);
                return null;
            }
            ArrayList nodes = new ArrayList();
            if (nodeMap != null && !nodeMap.isEmpty()) {
                nodeMap.keySet().forEach(nodeId -> nodes.add(this.nodeDao.get((Serializable)nodeId)));
            }
            for (OnmsNode node : nodes) {
                String foreignId = node.getForeignId() != null ? "" : "foreignId=" + node.getForeignId();
                String foreignSource = node.getForeignSource() != null ? "" : "foreignSource=" + node.getForeignSource();
                String location = this.nodeDao.getLocationForId(node.getId());
                System.out.printf("\nnodeId=%d nodeLabel=%s location=%s %s %s \n", node.getId(), node.getLabel(), location, foreignId, foreignSource);
                ArrayList categoryNames = new ArrayList();
                node.getCategories().forEach(category -> categoryNames.add(category.getName()));
                if (!node.getCategories().isEmpty()) {
                    System.out.printf("\tcategories: \n", new Object[0]);
                    categoryNames.stream().forEach(name -> System.out.printf("\t\t%s", name));
                }
                ArrayList matchingIpAddresses = new ArrayList();
                matchingInetAddressList.stream().forEach(ipAddress -> matchingIpAddresses.add(ipAddress.getHostAddress()));
                System.out.printf("\tIpAddresses: \n", new Object[0]);
                ArrayList interfacesOnNode = new ArrayList();
                node.getIpInterfaces().forEach(ipInterface -> interfacesOnNode.add(ipInterface.getIpAddress().getHostAddress()));
                interfacesOnNode.stream().filter(matchingIpAddresses::contains).collect(Collectors.toList()).forEach(ipAddress -> System.out.printf("\t\t%s \n", ipAddress));
            }
            System.out.flush();
            return null;
        });
        return null;
    }
}

