/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.shell;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.shell.MonitorClassNameCompleter;
import org.opennms.netmgt.poller.shell.ReadOnlyPollerConfigManager;
import org.opennms.netmgt.poller.support.SimpleMonitoredService;

@Command(scope="opennms-poller", name="poll", description="Used to invoke a monitor against a host at a specific location, or to test a service monitor definition from a given poller package.")
@org.apache.karaf.shell.api.action.lifecycle.Service
public class Poll
implements Action {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location = "Default";
    @Option(name="-S", aliases={"--service"}, description="Service name", required=false, multiValued=false)
    String serviceName;
    @Option(name="-P", aliases={"--package"}, description="Poller Package", required=false, multiValued=false)
    String packageName;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String systemId;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live", required=false, multiValued=false)
    Long ttlInMs;
    @Option(name="-n", aliases={"--node-id"}, description="Node Id for Service", required=false, multiValued=false)
    int nodeId;
    @Option(name="-c", aliases={"--class"}, description="Monitor Class", required=false, multiValued=false)
    @Completion(value=MonitorClassNameCompleter.class)
    String className;
    @Argument(index=0, name="host", description="Hostname or IP Address of the system to poll", required=true, multiValued=false)
    String host;
    @Argument(index=1, name="attributes", description="Monitor specific attributes in key=value form", multiValued=true)
    List<String> attributes;
    @Reference
    public LocationAwarePollerClient locationAwarePollerClient;
    @Reference
    public NodeDao nodeDao;
    @Reference
    public IpInterfaceDao ipInterfaceDao;
    @Reference
    public SessionUtils sessionUtils;

    public Object execute() throws Exception {
        InetAddress ipAddress = InetAddress.getByName(this.host);
        if (this.className == null) {
            if (this.serviceName == null) {
                System.err.println("Please specify at least the monitor class (--class) or the package/service (--package/--service)\n");
                return null;
            }
            this.className = this.retrieveClassName(ipAddress, this.packageName, this.serviceName);
            if (this.className == null) {
                return null;
            }
        }
        MonitoredService service = (MonitoredService)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsNode node;
            if (this.nodeId > 0) {
                node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(this.nodeId));
                if (node == null) {
                    System.err.printf("Error: Can't find node with Id %d the database%n", this.nodeId);
                    return null;
                }
            } else {
                List ips = this.ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)ipAddress)).stream().filter(i -> this.location.equals(i.getNode().getLocation().getLocationName())).collect(Collectors.toList());
                if (ips.size() == 0) {
                    System.err.printf("Error: Can't find the IP address %s on the database%n", InetAddressUtils.str((InetAddress)ipAddress));
                    return null;
                }
                if (ips.size() > 1) {
                    System.out.printf("Warning: there are several IP interface objects associated with the IP address %s (picking the first one)%n", InetAddressUtils.str((InetAddress)ipAddress));
                }
                node = ((OnmsIpInterface)ips.get(0)).getNode();
            }
            return new SimpleMonitoredService(ipAddress, node.getId().intValue(), node.getLabel(), this.serviceName == null ? "SVC" : this.serviceName, this.location);
        });
        Map<String, Object> parameters = this.retrieveParameters(ipAddress, this.packageName, this.serviceName);
        parameters.putAll(Poll.parse(this.attributes));
        CompletableFuture future = this.locationAwarePollerClient.poll().withService(service).withSystemId(this.systemId).withMonitorClassName(this.className).withTimeToLive(this.ttlInMs).withAttributes(parameters).execute();
        if (this.packageName != null) {
            System.out.printf("Package: %s%n", this.packageName);
        }
        if (this.serviceName != null) {
            System.out.printf("Service: %s%n", this.serviceName);
        }
        if (this.className != null) {
            System.out.printf("Monitor: %s%n", this.className);
        }
        for (Map.Entry<String, Object> e2 : parameters.entrySet()) {
            System.out.printf("Parameter %s: %s%n", e2.getKey(), e2.getValue());
        }
        while (true) {
            try {
                try {
                    PollStatus pollStatus = ((PollerResponse)future.get(1L, TimeUnit.SECONDS)).getPollStatus();
                    if (pollStatus.getStatusCode() == 1) {
                        System.out.printf("\nService is %s on %s using %s:\n", pollStatus.getStatusName(), this.host, this.className);
                        Map properties = pollStatus.getProperties();
                        if (properties.size() > 0) {
                            properties.entrySet().stream().forEach(e -> System.out.printf("\t%s: %.4f\n", e.getKey(), e.getValue() != null ? Double.valueOf(((Number)e.getValue()).doubleValue()) : null));
                            break;
                        }
                        System.out.printf("(No properties were returned by the monitor.\n", new Object[0]);
                        break;
                    }
                    System.out.printf("\nService is %s on %s using %s\n", pollStatus.getStatusName(), this.host, this.className);
                    System.out.printf("\tReason: %s\n", pollStatus.getReason());
                }
                catch (InterruptedException e3) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e4) {
                    System.out.printf("\nPoll failed with: %s\n", e4);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    private String retrieveClassName(InetAddress ipAddress, String packageName, String serviceName) throws Exception {
        Package pkg;
        ReadOnlyPollerConfigManager pollerConfig = ReadOnlyPollerConfigManager.create();
        Package package_ = pkg = packageName == null ? pollerConfig.getFirstLocalPackageMatch(InetAddressUtils.str((InetAddress)ipAddress)) : pollerConfig.getPackage(packageName);
        if (pkg == null) {
            System.err.printf("Error: Package %s doesn't exist%n", packageName);
            return null;
        }
        Service svc = pollerConfig.getServiceInPackage(serviceName, pkg);
        if (svc == null) {
            System.err.printf("Error: Service %s not defined on package %s%n", serviceName, packageName);
            return null;
        }
        Optional service = pkg.findService(serviceName);
        if (!service.isPresent()) {
            System.err.printf("Error: Service %s not defined%n", serviceName);
            return null;
        }
        ServiceMonitor monitor = pollerConfig.getServiceMonitor(((Package.ServiceMatch)service.get()).service.getName());
        if (monitor == null) {
            System.err.printf("Error: Service %s doesn't have a monitor class defined%n", serviceName);
            return null;
        }
        return monitor.getClass().getName();
    }

    private Map<String, Object> retrieveParameters(InetAddress ipAddress, String packageName, String serviceName) throws Exception {
        Package pkg;
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        if (serviceName == null) {
            return parameters;
        }
        ReadOnlyPollerConfigManager pollerConfig = ReadOnlyPollerConfigManager.create();
        Package package_ = pkg = packageName == null ? pollerConfig.getFirstLocalPackageMatch(InetAddressUtils.str((InetAddress)ipAddress)) : pollerConfig.getPackage(packageName);
        if (pkg == null) {
            System.err.printf("Error: Package %s doesn't exist%n", packageName);
            return parameters;
        }
        Service svc = pollerConfig.getServiceInPackage(serviceName, pkg);
        if (svc == null) {
            System.err.printf("Error: Service %s not defined on package %s%n", serviceName, packageName);
            return parameters;
        }
        Optional service = pkg.findService(serviceName);
        if (!service.isPresent()) {
            System.err.printf("Error: Service %s not defined%n", serviceName);
            return parameters;
        }
        for (Parameter parameter : svc.getParameters()) {
            String value = parameter.getValue();
            if (value == null) {
                try {
                    value = JaxbUtils.marshal((Object)parameter.getAnyObject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            parameters.put(parameter.getKey(), value);
        }
        return parameters;
    }

    protected static Map<String, Object> parse(List<String> attributeList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

