/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.shell;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.opennms.netmgt.poller.shell.Poll;
import org.opennms.netmgt.poller.shell.ReadOnlyPollerConfigManager;
import org.opennms.netmgt.poller.support.SimpleMonitoredService;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

@Command(scope="poller", name="test", description="Execute a poller test from the command line using current settings from poller-configuration.xml")
public class Test
extends OsgiCommandSupport {
    @Option(name="-i", aliases={"--ipaddress"}, description="IP Address to test", required=true, multiValued=false)
    String ipAddress;
    @Option(name="-s", aliases={"--service"}, description="Service name", required=true, multiValued=false)
    String serviceName;
    @Option(name="-P", aliases={"--package"}, description="Poller Package", required=false, multiValued=false)
    String packageName;
    @Option(name="-p", aliases={"--param"}, description="Service parameter ~ key=value", required=false, multiValued=true)
    List<String> serviceParameters;
    @Option(name="-c", aliases={"--class"}, description="Monitor Class", required=false, multiValued=false)
    String monitorClass;
    private ServiceMonitorRegistry registry;
    private IpInterfaceDao ipInterfaceDao;
    private TransactionOperations transactionTemplate;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object doExecute() throws Exception {
        Package pkg;
        final InetAddress addr = InetAddressUtils.addr((String)this.ipAddress);
        if (addr == null) {
            throw new IllegalStateException("Error getting InetAddress object for " + this.ipAddress);
        }
        Map<String, Object> parameters = Poll.parse(this.serviceParameters);
        MonitoredService monSvc = (MonitoredService)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<MonitoredService>(){

            public MonitoredService doInTransaction(TransactionStatus status) {
                List ips = Test.this.ipInterfaceDao.findByIpAddress(Test.this.ipAddress);
                if (ips == null || ips.size() == 0) {
                    System.err.printf("Error: Can't find the IP address %s on the database\n", Test.this.ipAddress);
                    return null;
                }
                if (ips.size() > 1) {
                    System.out.printf("Warning: there are several IP interface objects associated with the IP address %s (picking the first one)\n", Test.this.ipAddress);
                }
                OnmsNode n = ((OnmsIpInterface)ips.get(0)).getNode();
                return new SimpleMonitoredService(addr, n.getId().intValue(), n.getLabel(), Test.this.serviceName);
            }
        });
        if (monSvc == null) {
            return null;
        }
        ReadOnlyPollerConfigManager pollerConfig = ReadOnlyPollerConfigManager.create();
        System.out.printf("Checking service %s on IP %s%n", this.serviceName, this.ipAddress);
        Package package_ = pkg = this.packageName == null ? pollerConfig.getFirstLocalPackageMatch(this.ipAddress) : pollerConfig.getPackage(this.packageName);
        if (pkg == null) {
            System.err.printf("Error: Package %s doesn't exist%n", this.packageName);
            return null;
        }
        System.out.printf("Package: %s%n", pkg.getName());
        Service svc = pollerConfig.getServiceInPackage(this.serviceName, pkg);
        if (svc == null) {
            System.err.printf("Error: Service %s not defined on package %s%n", this.serviceName, this.packageName);
            return null;
        }
        ServiceMonitor monitor = null;
        if (this.monitorClass == null) {
            monitor = pollerConfig.getServiceMonitor(this.serviceName);
            if (monitor == null) {
                System.err.printf("Error: Service %s doesn't have a monitor class defined%n", this.serviceName);
                return null;
            }
        } else {
            monitor = this.registry.getMonitorByClassName(this.monitorClass);
            System.err.printf("Error: No monitor found with class name %s\n", this.monitorClass);
            if (monitor == null) {
                return null;
            }
        }
        System.out.printf("Monitor: %s%n", monitor.getClass().getName());
        if (pollerConfig.isPolledLocally(this.ipAddress, this.serviceName)) {
            for (Parameter parameter : svc.getParameters()) {
                if (parameters.containsKey(parameter.getKey())) continue;
                String value = parameter.getValue();
                if (value == null) {
                    try {
                        value = JaxbUtils.marshal((Object)parameter.getAnyObject());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                parameters.put(parameter.getKey(), value);
            }
            for (Map.Entry entry : parameters.entrySet()) {
                System.out.printf("Parameter %s : %s%n", entry.getKey(), entry.getValue());
            }
            try {
                PollStatus status = monitor.poll(monSvc, parameters);
                System.out.printf("Available ? %s (status %s[%s])%n", status.isAvailable(), status.getStatusName(), status.getStatusCode());
                if (status.isAvailable()) {
                    System.out.printf("Response time: %s%n", status.getResponseTime());
                    return null;
                }
                if (status.getReason() == null) return null;
                System.out.printf("Reason: %s%n", status.getReason());
                return null;
            }
            catch (Exception e) {
                System.err.println("Error: Can't execute the monitor. " + e.getMessage());
                return null;
            }
        }
        System.err.printf("Error: Polling is not enabled for service %s using IP %s%n", this.serviceName, this.ipAddress);
        return null;
    }

    public void setRegistry(ServiceMonitorRegistry registry) {
        this.registry = registry;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = ipInterfaceDao;
    }

    public void setTransactionTemplate(TransactionOperations transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

