/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.shell;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.support.SimpleMonitoredService;

@Command(scope="poller", name="poll", description="Used to invoke a monitor against a host at a specified location")
public class Poll
extends OsgiCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live", required=false, multiValued=false)
    Long ttlInMs;
    @Argument(index=0, name="monitorClass", description="Monitor class", required=true, multiValued=false)
    String className;
    @Argument(index=1, name="host", description="Hostname or IP Address of the system to poll", required=true, multiValued=false)
    String host;
    @Argument(index=2, name="attributes", description="Monitor specific attributes in key=value form", multiValued=true)
    List<String> attributes;
    private LocationAwarePollerClient locationAwarePollerClient;

    protected Object doExecute() throws Exception {
        CompletableFuture future = this.locationAwarePollerClient.poll().withService((MonitoredService)new SimpleMonitoredService(InetAddress.getByName(this.host), "SVC", this.location)).withMonitorClassName(this.className).withTimeToLive(this.ttlInMs).withAttributes(Poll.parse(this.attributes)).execute();
        while (true) {
            try {
                try {
                    PollStatus pollStatus = ((PollerResponse)future.get(1L, TimeUnit.SECONDS)).getPollStatus();
                    if (pollStatus.getStatusCode() == 1) {
                        System.out.printf("\nService is %s on %s using %s:\n", pollStatus.getStatusName(), this.host, this.className);
                        Map properties = pollStatus.getProperties();
                        if (properties.size() > 0) {
                            properties.entrySet().stream().forEach(e -> System.out.printf("\t%s: %.4f\n", e.getKey(), e.getValue()));
                            break;
                        }
                        System.out.printf("(No properties were returned by the monitor.\n", new Object[0]);
                        break;
                    }
                    System.out.printf("\nService is %s on %s using %s\n", pollStatus.getStatusName(), this.host, this.className);
                    System.out.printf("\tReason: %s\n", pollStatus.getReason());
                }
                catch (InterruptedException e2) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e3) {
                    System.out.printf("\nPoll failed with: %s\n", e3);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    public void setLocationAwarePollerClient(LocationAwarePollerClient locationAwarePollerClient) {
        this.locationAwarePollerClient = locationAwarePollerClient;
    }

    protected static Map<String, Object> parse(List<String> attributeList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

