/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerTheme;
import org.opennms.netmgt.poller.remote.metadata.MetadataField;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;

public class ServerUnreachableAdaptor
implements PollerBackEnd {
    private static final Logger LOG = LoggerFactory.getLogger(ServerUnreachableAdaptor.class);
    private String m_monitorName;
    private PollerBackEnd m_remoteBackEnd;
    private boolean m_serverUnresponsive = false;

    public void setRemoteBackEnd(PollerBackEnd remoteBackEnd) {
        this.m_remoteBackEnd = remoteBackEnd;
    }

    @Override
    public void checkForDisconnectedMonitors() {
    }

    @Override
    public void configurationUpdated() {
    }

    @Override
    public Collection<OnmsMonitoringLocation> getMonitoringLocations() {
        return this.m_remoteBackEnd.getMonitoringLocations();
    }

    @Override
    public PollerConfiguration getPollerConfiguration(String locationMonitorId) {
        if (this.m_serverUnresponsive) {
            return new EmptyPollerConfiguration();
        }
        try {
            PollerConfiguration config = this.m_remoteBackEnd.getPollerConfiguration(locationMonitorId);
            this.m_serverUnresponsive = false;
            return config;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return new EmptyPollerConfiguration();
        }
    }

    @Override
    public PollerConfiguration getPollerConfigurationForLocation(String location) {
        if (this.m_serverUnresponsive) {
            return new EmptyPollerConfiguration();
        }
        try {
            PollerConfiguration config = this.m_remoteBackEnd.getPollerConfigurationForLocation(location);
            this.m_serverUnresponsive = false;
            return config;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return new EmptyPollerConfiguration();
        }
    }

    @Override
    public Set<String> getApplicationsForLocation(String location) {
        if (this.m_serverUnresponsive) {
            return Collections.emptySet();
        }
        try {
            Set<String> applications = this.m_remoteBackEnd.getApplicationsForLocation(location);
            this.m_serverUnresponsive = false;
            return applications;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(String locationMonitorId, Date currentConfigurationVersion) {
        try {
            OnmsLocationMonitor.MonitorStatus result = this.m_remoteBackEnd.pollerCheckingIn(locationMonitorId, currentConfigurationVersion);
            this.m_serverUnresponsive = false;
            return result;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return OnmsLocationMonitor.MonitorStatus.DISCONNECTED;
        }
    }

    @Override
    public boolean pollerStarting(String locationMonitorId, Map<String, String> pollerDetails) {
        try {
            boolean pollerStarting = this.m_remoteBackEnd.pollerStarting(locationMonitorId, pollerDetails);
            if (pollerStarting) {
                this.m_monitorName = this.m_remoteBackEnd.getMonitorName(locationMonitorId);
            }
            this.m_serverUnresponsive = false;
            return pollerStarting;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return true;
        }
    }

    @Override
    public void pollerStopping(String locationMonitorId) {
        this.m_remoteBackEnd.pollerStopping(locationMonitorId);
    }

    @Override
    public String registerLocationMonitor(String monitoringLocationId) {
        return this.m_remoteBackEnd.registerLocationMonitor(monitoringLocationId);
    }

    @Override
    public void reportResult(String locationMonitorID, int serviceId, PollStatus status) {
        if (!this.m_serverUnresponsive) {
            try {
                this.m_remoteBackEnd.reportResult(locationMonitorID, serviceId, status);
            }
            catch (RemoteAccessException e) {
                this.m_serverUnresponsive = true;
                LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            }
        }
    }

    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            return this.m_remoteBackEnd.getServiceMonitorLocators(context);
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getMonitorName(String locationMonitorId) {
        try {
            return this.m_remoteBackEnd.getMonitorName(locationMonitorId);
        }
        catch (RemoteAccessException e) {
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return this.m_monitorName == null ? "" + locationMonitorId : this.m_monitorName;
        }
    }

    @Override
    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        try {
            this.m_remoteBackEnd.saveResponseTimeData(locationMonitor, monSvc, responseTime, pkg);
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
        }
    }

    @Override
    public void reportSingleScan(ScanReport report) {
        try {
            this.m_remoteBackEnd.reportSingleScan(report);
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
        }
    }

    @Override
    public Set<MetadataField> getMetadataFields() {
        try {
            return this.m_remoteBackEnd.getMetadataFields();
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public PollerTheme getTheme() {
        try {
            return this.m_remoteBackEnd.getTheme();
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LOG.warn("Server is unable to respond due to the following exception.", (Throwable)e);
            return new PollerTheme();
        }
    }
}

