/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.LtRestriction;
import org.opennms.core.criteria.restrictions.NotNullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.ScanReportDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.ScanReportPollResult;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerTheme;
import org.opennms.netmgt.poller.remote.RemoteHostThreadLocal;
import org.opennms.netmgt.poller.remote.metadata.MetadataField;
import org.opennms.netmgt.poller.remote.metadata.MetadataFieldReader;
import org.opennms.netmgt.poller.remote.support.DistributedLatencyCollectionAttribute;
import org.opennms.netmgt.poller.remote.support.DistributedLatencyCollectionAttributeType;
import org.opennms.netmgt.poller.remote.support.DistributedLatencyCollectionResource;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class DefaultPollerBackEnd
implements PollerBackEnd,
SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollerBackEnd.class);
    public static final int HEARTBEAT_STEP_MULTIPLIER = 2;
    public static final String PARM_SCAN_REPORT_ID = "scanReportId";
    public static final String PARM_SCAN_REPORT_LOCATION = "scanReportLocation";
    public static final String PARM_SCAN_REPORT_FAILURE_MESSAGE = "scanReportFailureMessage";
    private final MetadataFieldReader m_metadataFieldReader = new MetadataFieldReader();
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private ScanReportDao m_scanReportDao;
    private EventIpcManager m_eventIpcManager;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private int m_disconnectedTimeout;
    @Autowired
    private PersisterFactory m_persisterFactory;
    private long m_minimumConfigurationReloadInterval;
    private final AtomicReference<Date> m_configurationTimestamp = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, SimplePollerConfiguration>> m_configCache = new AtomicReference();
    public static final String FAILURE_SUMMARY_MESSAGE_FORMAT = "<p>%d out of %d service polls failed for the following reasons:</p>";
    public static final String FAILED_POLL_RESULT_MESSAGE_FORMAT = "<li><b>%s: %s: %s:</b> %s</li>";

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_locMonDao, (String)"The LocationMonitorDao must be set");
        Assert.notNull((Object)this.m_monSvcDao, (String)"The MonitoredServiceDao must be set");
        Assert.notNull((Object)this.m_pollerConfig, (String)"The PollerConfig must be set");
        Assert.notNull((Object)this.m_timeKeeper, (String)"The timeKeeper must be set");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"The eventIpcManager must be set");
        Assert.state((this.m_disconnectedTimeout > 0 ? 1 : 0) != 0, (String)"the disconnectedTimeout property must be set");
        Assert.notNull((Object)this.m_persisterFactory, (String)"The persisterFactory must be set");
        this.m_minimumConfigurationReloadInterval = Long.getLong("opennms.pollerBackend.minimumConfigurationReloadInterval", 300000L);
        this.configurationUpdated();
    }

    public void start() {
    }

    public void destroy() {
    }

    @Override
    public void checkForDisconnectedMonitors() {
        LOG.debug("Checking for disconnected monitors: disconnectedTimeout = {}", (Object)this.m_disconnectedTimeout);
        try {
            Date now = this.m_timeKeeper.getCurrentDate();
            Date earliestAcceptable = new Date(now.getTime() - (long)this.m_disconnectedTimeout);
            Criteria criteria = new Criteria(OnmsLocationMonitor.class);
            criteria.addRestriction((Restriction)new EqRestriction("status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED));
            criteria.addRestriction((Restriction)new NotNullRestriction("lastUpdated"));
            criteria.addRestriction((Restriction)new LtRestriction("lastUpdated", (Object)earliestAcceptable));
            criteria.setLockType(Criteria.LockType.PESSIMISTIC_READ);
            List monitors = this.m_locMonDao.findMatching(criteria);
            LOG.debug("Found {} monitor(s) that are transitioning to disconnected state", (Object)monitors.size());
            for (OnmsLocationMonitor monitor : monitors) {
                LOG.debug("Monitor {} has stopped responding", (Object)monitor.getName());
                monitor.setStatus(OnmsLocationMonitor.MonitorStatus.DISCONNECTED);
                this.m_locMonDao.update((Object)monitor);
                this.sendDisconnectedEvent(monitor);
            }
        }
        catch (Throwable e) {
            LOG.warn("An error occurred checking for disconnected monitors.", e);
        }
    }

    private OnmsLocationMonitor.MonitorStatus checkForGlobalConfigChange(Date currentConfigurationVersion) {
        if (this.configurationUpdateIsNeeded(currentConfigurationVersion)) {
            return OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
        }
        return OnmsLocationMonitor.MonitorStatus.STARTED;
    }

    private boolean configurationUpdateIsNeeded(Date currentConfigurationVersion) {
        if (this.configIntervalExceedsMinimalInterval(currentConfigurationVersion)) {
            return this.m_configurationTimestamp.get().after(currentConfigurationVersion);
        }
        return false;
    }

    private boolean configIntervalExceedsMinimalInterval(Date currentConfigurationVersion) {
        return this.m_minimumConfigurationReloadInterval > 0L && this.m_timeKeeper.getCurrentTime() - currentConfigurationVersion.getTime() > this.m_minimumConfigurationReloadInterval;
    }

    @Override
    public void configurationUpdated() {
        this.m_configurationTimestamp.set(this.m_timeKeeper.getCurrentDate());
        this.m_configCache.set(new ConcurrentHashMap());
    }

    private static EventBuilder createEventBuilder(OnmsLocationMonitor mon, String uei) {
        EventBuilder eventBuilder = new EventBuilder(uei, "PollerBackEnd").addParam("locationMonitorId", mon.getId()).addParam("location", mon.getLocation());
        return eventBuilder;
    }

    private boolean databaseStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus == null || !currentStatus.getPollResult().equals((Object)newStatus.getPollResult());
    }

    private Date getConfigurationTimestamp() {
        return this.m_configurationTimestamp.get();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<OnmsMonitoringLocation> getMonitoringLocations() {
        return this.m_monitoringLocationDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public String getMonitorName(String locationMonitorId) {
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.load((Serializable)((Object)locationMonitorId));
        return locationMonitor.getName();
    }

    protected static Map<String, Object> getParameterMap(Service serviceConfig) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Parameter serviceParm : serviceConfig.getParameters()) {
            String value = serviceParm.getValue();
            if (value == null) {
                Object o = serviceParm.getAnyObject();
                value = o == null ? "" : (o instanceof PageSequence ? JaxbUtils.marshal((Object)o) : o.toString());
            }
            paramMap.put(serviceParm.getKey(), value);
        }
        return paramMap;
    }

    @Override
    @Transactional(readOnly=true)
    public PollerConfiguration getPollerConfiguration(String locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        if (mon == null) {
            LOG.warn("No location monitor found for location monitor ID {}", (Object)locationMonitorId);
            return new EmptyPollerConfiguration();
        }
        return this.getPollerConfigurationForLocation(mon.getLocation());
    }

    @Override
    @Transactional(readOnly=true)
    public PollerConfiguration getPollerConfigurationForLocation(String location) {
        try {
            List<String> pollingPackageNames = this.getPackageNameForLocation(location);
            LOG.debug("Location {} has polling packages: {}", (Object)location, pollingPackageNames);
            ArrayList<SimplePollerConfiguration> addMe = new ArrayList<SimplePollerConfiguration>();
            for (String pollingPackageName : pollingPackageNames) {
                SimplePollerConfiguration configInCache;
                ConcurrentHashMap<String, SimplePollerConfiguration> cache = this.m_configCache.get();
                SimplePollerConfiguration pollerConfiguration = cache.get(pollingPackageName);
                if (pollerConfiguration == null && (configInCache = cache.putIfAbsent(pollingPackageName, pollerConfiguration = this.createPollerConfiguration(pollingPackageName))) != null) {
                    pollerConfiguration = configInCache;
                }
                addMe.add(pollerConfiguration);
            }
            return new SimplePollerConfiguration(addMe.toArray(new SimplePollerConfiguration[0]));
        }
        catch (Exception e) {
            LOG.warn("An error occurred retrieving the poller configuration for location {}", (Object)location, (Object)e);
            return new EmptyPollerConfiguration();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getApplicationsForLocation(String location) {
        HashSet<String> retval = new HashSet<String>();
        PollerConfiguration config = this.getPollerConfigurationForLocation(location);
        for (PolledService service : config.getPolledServices()) {
            retval.addAll(service.getApplications());
        }
        return Collections.unmodifiableSet(retval);
    }

    private SimplePollerConfiguration createPollerConfiguration(String pollingPackageName) {
        Package pkg = this.getPollingPackage(pollingPackageName);
        ServiceSelector selector = this.m_pollerConfig.getServiceSelectorForPackage(pkg);
        List services = this.m_monSvcDao.findMatchingServices(selector);
        ArrayList<PolledService> configs = new ArrayList<PolledService>(services.size());
        LOG.debug("Found {} services in polling package {}", (Object)services.size(), (Object)pollingPackageName);
        for (OnmsMonitoredService monSvc : services) {
            Service serviceConfig = this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg);
            long interval = serviceConfig.getInterval();
            Map<String, Object> parameters = DefaultPollerBackEnd.getParameterMap(serviceConfig);
            if (LOG.isTraceEnabled()) {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    LOG.trace("Service {} has parameter {} with type {} and value: {}", new Object[]{monSvc.getServiceName(), entry.getKey(), entry.getValue() != null ? entry.getValue().getClass().getCanonicalName() : "null", entry.getValue()});
                }
            }
            configs.add(new PolledService(monSvc, parameters, new OnmsPollModel(interval)));
        }
        Collections.sort(configs);
        return new SimplePollerConfiguration(this.getConfigurationTimestamp(), configs.toArray(new PolledService[configs.size()]));
    }

    private Package getPollingPackageForMonitorAndService(OnmsLocationMonitor mon, OnmsMonitoredService monSvc) {
        List<String> pollingPackageNames = this.getPackageName(mon);
        for (String pollingPackageName : pollingPackageNames) {
            Package pkg = this.getPollingPackage(pollingPackageName);
            if (this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg) == null) continue;
            return pkg;
        }
        throw new IllegalStateException("Could not find package from monitor " + mon.getName() + " that contains service " + monSvc.getServiceName());
    }

    private Package getPollingPackage(String pollingPackageName) {
        Package pkg = this.m_pollerConfig.getPackage(pollingPackageName);
        if (pkg == null) {
            throw new IllegalStateException("Package " + pollingPackageName + " does not exist");
        }
        return pkg;
    }

    private List<String> getPackageName(OnmsLocationMonitor mon) {
        return this.getPackageNameForLocation(mon.getLocation());
    }

    private List<String> getPackageNameForLocation(String location) {
        OnmsMonitoringLocation def = (OnmsMonitoringLocation)this.m_monitoringLocationDao.get((Serializable)((Object)location));
        if (def == null) {
            throw new IllegalStateException("Location definition '" + location + "' could not be found");
        }
        return def.getPollingPackageNames();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
            List<String> ex = Arrays.asList(System.getProperty("excludeServiceMonitorsFromRemotePoller", "").trim().split("\\s*,\\s*"));
            for (ServiceMonitorLocator locator : this.m_pollerConfig.getServiceMonitorLocators(context)) {
                if (ex.contains(locator.getServiceName())) continue;
                locators.add(locator);
            }
            LOG.debug("getServiceMonitorLocators: Returning {} locators", (Object)locators.size());
            return locators;
        }
        catch (Exception e) {
            LOG.warn("An error occurred getting the service monitor locators for distribution context: {}", (Object)context, (Object)e);
            return Collections.emptyList();
        }
    }

    private boolean logicalStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus != null || !newStatus.getPollResult().isAvailable();
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(String locationMonitorId, Date currentConfigurationVersion) {
        try {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
            if (mon == null) {
                LOG.debug("Deleted monitor checked in with ID {}", (Object)locationMonitorId);
                return OnmsLocationMonitor.MonitorStatus.DELETED;
            }
            return this.updateMonitorState(mon, currentConfigurationVersion);
        }
        catch (Throwable e) {
            LOG.warn("An error occurred while checking in.", e);
            return OnmsLocationMonitor.MonitorStatus.DISCONNECTED;
        }
    }

    @Override
    public boolean pollerStarting(String locationMonitorId, Map<String, String> pollerDetails) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        if (mon == null) {
            return false;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
        this.updateConnectionHostDetails(mon, pollerDetails);
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStartedEvent(mon);
        return true;
    }

    protected void updateConnectionHostDetails(OnmsLocationMonitor mon, Map<String, String> pollerDetails) {
        HashMap<String, String> allDetails = new HashMap<String, String>();
        if (pollerDetails != null) {
            allDetails.putAll(pollerDetails);
        }
        String oldConnectionHostAddress = (String)allDetails.get("org.opennms.netmgt.poller.remote.connectionHostAddress");
        String newConnectionHostAddress = null;
        String remoteHost = (String)RemoteHostThreadLocal.INSTANCE.get();
        if (remoteHost != null) {
            remoteHost = remoteHost.trim();
            allDetails.put("org.opennms.netmgt.poller.remote.connectionHostName", remoteHost);
            try {
                InetAddress addr = InetAddressUtils.getInetAddress((String)remoteHost);
                newConnectionHostAddress = InetAddressUtils.str((InetAddress)addr);
                allDetails.put("org.opennms.netmgt.poller.remote.connectionHostAddress", newConnectionHostAddress);
                if (remoteHost.equals(newConnectionHostAddress)) {
                    allDetails.put("org.opennms.netmgt.poller.remote.connectionHostName", addr.getHostName());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mon.setProperties(allDetails);
        if (oldConnectionHostAddress == null) {
            if (newConnectionHostAddress != null) {
                this.sendMonitorRemoteAddressChangedEvent(mon, oldConnectionHostAddress, newConnectionHostAddress);
            }
        } else if (!oldConnectionHostAddress.equals(newConnectionHostAddress)) {
            this.sendMonitorRemoteAddressChangedEvent(mon, oldConnectionHostAddress, newConnectionHostAddress);
        }
    }

    private void sendMonitorRemoteAddressChangedEvent(OnmsLocationMonitor mon, String oldRemoteHostAddress, String newRemoteHostAddress) {
        this.m_eventIpcManager.sendNow(DefaultPollerBackEnd.createEventBuilder(mon, "uei.opennms.org/remote/locationMonitorConnectionAddressChanged").addParam("oldConnectionHostAddress", oldRemoteHostAddress).addParam("newConnectionHostAddress", newRemoteHostAddress).getEvent());
    }

    @Override
    public void pollerStopping(String locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        if (mon == null) {
            LOG.info("pollerStopping was called for location monitor ID {} which does not exist", (Object)locationMonitorId);
            return;
        }
        if (mon.getStatus() != OnmsLocationMonitor.MonitorStatus.PAUSED) {
            mon.setStatus(OnmsLocationMonitor.MonitorStatus.STOPPED);
        }
        mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStoppedEvent(mon);
    }

    private void processStatusChange(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        if (this.databaseStatusChanged(currentStatus, newStatus)) {
            this.m_locMonDao.saveStatusChange(newStatus);
            PollStatus pollResult = newStatus.getPollResult();
            if (this.logicalStatusChanged(currentStatus, newStatus)) {
                this.sendRegainedOrLostServiceEvent(newStatus, pollResult);
            }
        }
    }

    @Override
    public String registerLocationMonitor(String monitoringLocationId) {
        OnmsMonitoringLocation def = (OnmsMonitoringLocation)this.m_monitoringLocationDao.get((Serializable)((Object)monitoringLocationId));
        if (def == null) {
            throw new ObjectRetrievalFailureException(OnmsMonitoringLocation.class, (Object)monitoringLocationId, "Location monitor definition with the id '" + monitoringLocationId + "' not found", null);
        }
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setId(UUID.randomUUID().toString());
        mon.setLocation(def.getLocationName());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.REGISTERED);
        this.m_locMonDao.save((Object)mon);
        this.sendMonitorRegisteredEvent(mon);
        return mon.getId();
    }

    @Override
    public void reportResult(String locationMonitorId, int serviceId, PollStatus pollResult) {
        OnmsMonitoredService monSvc;
        OnmsLocationMonitor locationMonitor;
        try {
            locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        }
        catch (Exception e) {
            LOG.info("Unable to report result for location monitor ID {}: Location monitor does not exist.", (Object)locationMonitorId, (Object)e);
            return;
        }
        if (locationMonitor == null) {
            LOG.info("Unable to report result for location monitor ID {}: Location monitor does not exist.", (Object)locationMonitorId);
            return;
        }
        try {
            monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(serviceId));
        }
        catch (Exception e) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Monitored service does not exist.", new Object[]{locationMonitorId, serviceId, e});
            return;
        }
        if (monSvc == null) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Monitored service does not exist.", (Object)locationMonitorId, (Object)serviceId);
            return;
        }
        if (pollResult == null) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Poll result is null!", (Object)locationMonitorId, (Object)serviceId);
            return;
        }
        OnmsLocationSpecificStatus newStatus = new OnmsLocationSpecificStatus(locationMonitor, monSvc, pollResult);
        try {
            if (newStatus.getPollResult().getResponseTime() != null) {
                Package pkg = this.getPollingPackageForMonitorAndService(locationMonitor, monSvc);
                this.saveResponseTimeData(locationMonitorId, monSvc, newStatus.getPollResult().getResponseTime(), pkg);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to save response time data for location monitor ID {}, monitored service ID {}.", new Object[]{locationMonitorId, serviceId, e});
        }
        try {
            OnmsLocationSpecificStatus currentStatus = this.m_locMonDao.getMostRecentStatusChange(locationMonitor, monSvc);
            this.processStatusChange(currentStatus, newStatus);
        }
        catch (Exception e) {
            LOG.error("Unable to save result for location monitor ID {}, monitored service ID {}.", new Object[]{locationMonitorId, serviceId, e});
        }
    }

    @Override
    public void saveResponseTimeData(String locationMonitorId, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        String rrdRepository;
        String rrdBaseName;
        String svcName = monSvc.getServiceName();
        Service svc = this.m_pollerConfig.getServiceInPackage(svcName, pkg);
        String dsName = this.getServiceParameter(svc, "ds-name");
        if (dsName == null) {
            dsName = "response-time";
        }
        if ((rrdBaseName = this.getServiceParameter(svc, "rrd-base-name")) == null) {
            rrdBaseName = dsName;
        }
        if ((rrdRepository = this.getServiceParameter(svc, "rrd-repository")) == null) {
            return;
        }
        RrdRepository repository = new RrdRepository();
        repository.setStep(this.m_pollerConfig.getStep(pkg));
        repository.setHeartBeat(repository.getStep() * 2);
        repository.setRraList(this.m_pollerConfig.getRRAList(pkg));
        repository.setRrdBaseDir(new File(rrdRepository));
        DistributedLatencyCollectionResource distributedLatencyResource = new DistributedLatencyCollectionResource(locationMonitorId, InetAddressUtils.toIpAddrString((InetAddress)monSvc.getIpAddress()));
        DistributedLatencyCollectionAttributeType distributedLatencyType = new DistributedLatencyCollectionAttributeType(rrdBaseName, dsName);
        distributedLatencyResource.addAttribute((CollectionAttribute)new DistributedLatencyCollectionAttribute(distributedLatencyResource, distributedLatencyType, responseTime));
        ServiceParameters params = new ServiceParameters(Collections.emptyMap());
        Persister persister = this.m_persisterFactory.createPersister(params, repository, false, true, true);
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)distributedLatencyResource, new Date());
        collectionSet.setStatus(CollectionStatus.SUCCEEDED);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    private String getServiceParameter(Service svc, String key) {
        for (Parameter parm : this.m_pollerConfig.parameters(svc)) {
            if (!key.equals(parm.getKey())) continue;
            if (parm.getValue() != null) {
                return parm.getValue();
            }
            if (parm.getAnyObject() == null) continue;
            return parm.getAnyObject().toString();
        }
        return null;
    }

    private void sendMonitorRegisteredEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorRegistered");
    }

    private void sendDisconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorDisconnected");
    }

    private void sendEvent(OnmsLocationMonitor mon, String uei) {
        this.m_eventIpcManager.sendNow(DefaultPollerBackEnd.createEventBuilder(mon, uei).getEvent());
    }

    private void sendMonitorStartedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStarted");
    }

    private void sendMonitorStoppedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStopped");
    }

    private void sendReconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorReconnected");
    }

    private void sendSuccessfulScanReportEvent(String reportId, String locationName) {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/successfulScanReport", "PollerBackEnd");
        eventBuilder.addParam(PARM_SCAN_REPORT_ID, reportId);
        eventBuilder.addParam(PARM_SCAN_REPORT_LOCATION, locationName);
        this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
    }

    private void sendUnsuccessfulScanReportEvent(String reportId, String locationName, String failureMessage) {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/unsuccessfulScanReport", "PollerBackEnd");
        eventBuilder.addParam(PARM_SCAN_REPORT_ID, reportId);
        eventBuilder.addParam(PARM_SCAN_REPORT_LOCATION, locationName);
        eventBuilder.addParam(PARM_SCAN_REPORT_FAILURE_MESSAGE, failureMessage);
        this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
    }

    private void sendRegainedOrLostServiceEvent(OnmsLocationSpecificStatus newStatus, PollStatus pollResult) {
        String uei = pollResult.isAvailable() ? "uei.opennms.org/remote/nodes/nodeRegainedService" : "uei.opennms.org/remote/nodes/nodeLostService";
        EventBuilder builder = DefaultPollerBackEnd.createEventBuilder(newStatus.getLocationMonitor(), uei).setMonitoredService(newStatus.getMonitoredService());
        if (!pollResult.isAvailable() && pollResult.getReason() != null) {
            builder.addParam("eventReason", pollResult.getReason());
        }
        this.m_eventIpcManager.sendNow(builder.getEvent());
    }

    public void setDisconnectedTimeout(int disconnectedTimeout) {
        this.m_disconnectedTimeout = disconnectedTimeout;
    }

    public void setMinimumConfigurationReloadInterval(long value) {
        this.m_minimumConfigurationReloadInterval = value;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locMonDao) {
        this.m_locMonDao = locMonDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    public void setScanReportDao(ScanReportDao scanReportDao) {
        this.m_scanReportDao = scanReportDao;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    public void setPersisterFactory(PersisterFactory persisterFactory) {
        this.m_persisterFactory = persisterFactory;
    }

    private OnmsLocationMonitor.MonitorStatus updateMonitorState(OnmsLocationMonitor mon, Date currentConfigurationVersion) {
        try {
            switch (mon.getStatus()) {
                case DISCONNECTED: {
                    this.sendReconnectedEvent(mon);
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case STARTED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case PAUSED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.PAUSED;
                    return monitorStatus;
                }
                case CONFIG_CHANGED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
                    return monitorStatus;
                }
            }
            LOG.error("Unexpected monitor state for monitor: {}", (Object)mon);
            throw new IllegalStateException("Unexpected monitor state for monitor: " + mon);
        }
        finally {
            mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
            this.updateConnectionHostDetails(mon, mon.getProperties());
            this.m_locMonDao.update((Object)mon);
        }
    }

    @Override
    public void reportSingleScan(ScanReport report) {
        if (report == null) {
            throw new IllegalArgumentException("ScanReport cannot be null");
        }
        LOG.info("Scan report complete: {}", (Object)report);
        this.m_scanReportDao.save((Object)report);
        if (report.getPollResults().stream().allMatch(a -> a.getPollStatus().isAvailable())) {
            this.sendSuccessfulScanReportEvent(report.getId(), report.getLocation());
        } else {
            int total = 0;
            int failed = 0;
            StringBuffer failedPollResults = new StringBuffer();
            for (ScanReportPollResult result : report.getPollResults()) {
                ++total;
                if (result.getPollStatus().isAvailable()) continue;
                ++failed;
                failedPollResults.append(String.format(FAILED_POLL_RESULT_MESSAGE_FORMAT, result.getNodeLabel(), result.getIpAddress(), result.getServiceName(), result.getPollStatus().getReason()));
            }
            StringBuffer finalMessage = new StringBuffer();
            finalMessage.append(String.format(FAILURE_SUMMARY_MESSAGE_FORMAT, failed, total));
            finalMessage.append("<ul>");
            finalMessage.append(failedPollResults);
            finalMessage.append("</ul>");
            this.sendUnsuccessfulScanReportEvent(report.getId(), report.getLocation(), finalMessage.toString());
        }
    }

    @Override
    public PollerTheme getTheme() {
        return this.m_metadataFieldReader.getTheme();
    }

    @Override
    public Set<MetadataField> getMetadataFields() {
        try {
            return this.m_metadataFieldReader.getMetadataFields();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.warn("Failed to read metadata fields.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static class SimplePollerConfiguration
    implements PollerConfiguration,
    Serializable {
        private static final long serialVersionUID = 2L;
        private Date m_timestamp;
        private PolledService[] m_polledServices;
        private long m_serverTime = 0L;

        SimplePollerConfiguration(Date timestamp, PolledService[] polledSvcs) {
            this.m_timestamp = timestamp;
            this.m_polledServices = Arrays.copyOf(polledSvcs, polledSvcs.length);
            this.m_serverTime = System.currentTimeMillis();
        }

        public SimplePollerConfiguration(SimplePollerConfiguration ... pollerConfiguration) {
            this(SimplePollerConfiguration.getNewestTimestamp(pollerConfiguration), SimplePollerConfiguration.combinePolledServices(pollerConfiguration));
        }

        private static Date getNewestTimestamp(SimplePollerConfiguration ... pollerConfigurations) {
            if (pollerConfigurations == null || pollerConfigurations.length < 1) {
                return new Date(0L);
            }
            Date retval = new Date(0L);
            for (SimplePollerConfiguration config : pollerConfigurations) {
                Date current = config.getConfigurationTimestamp();
                if (!retval.before(current)) continue;
                retval = current;
            }
            return retval;
        }

        private static PolledService[] combinePolledServices(SimplePollerConfiguration ... pollerConfigurations) {
            if (pollerConfigurations == null || pollerConfigurations.length < 1) {
                return new PolledService[0];
            }
            TreeSet<PolledService> retval = new TreeSet<PolledService>();
            for (SimplePollerConfiguration config : pollerConfigurations) {
                PolledService[] services = config.getPolledServices();
                retval.addAll(Arrays.asList(services == null ? new PolledService[]{} : services));
            }
            return retval.toArray(new PolledService[0]);
        }

        @Override
        public Date getConfigurationTimestamp() {
            return this.m_timestamp;
        }

        @Override
        public PolledService[] getPolledServices() {
            return this.m_polledServices;
        }

        @Override
        public long getServerTime() {
            return this.m_serverTime;
        }
    }
}

