/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.logging.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.ScanReportLog;
import org.opennms.netmgt.model.ScanReportPollResult;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.ServicePollState;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedListener;
import org.opennms.netmgt.poller.remote.TimeAdjustment;
import org.opennms.netmgt.poller.remote.support.FatalExceptionOccurred;
import org.opennms.netmgt.poller.remote.support.Log4j2StringAppender;
import org.opennms.netmgt.poller.remote.support.PollerFrontEndState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ScanReportPollerFrontEnd
implements PollerFrontEnd,
InitializingBean,
DisposableBean {
    private static final PolledService[] POLLED_SERVICE_ARRAY = new PolledService[0];
    private static final Logger LOG = LoggerFactory.getLogger(ScanReportPollerFrontEnd.class);
    private PollerFrontEndState m_state = new Initial();
    private PollerBackEnd m_backEnd;
    private PollService m_pollService;
    private TimeAdjustment m_timeAdjustment;
    private List<PropertyChangeListener> m_propertyChangeListeners = new LinkedList<PropertyChangeListener>();
    private PollerConfiguration m_pollerConfiguration;
    private Map<String, String> m_metadata = Collections.emptyMap();
    private Set<String> m_selectedApplications = null;
    private String m_location;

    @Override
    public void addConfigurationChangedListener(ConfigurationChangedListener l) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.add(0, listener);
    }

    @Override
    public void addServicePollStateChangedListener(ServicePollStateChangedListener listener) {
    }

    public void afterPropertiesSet() {
        ScanReportPollerFrontEnd.assertNotNull(this.m_timeAdjustment, "timeAdjustment");
        ScanReportPollerFrontEnd.assertNotNull(this.m_backEnd, "pollerBackEnd");
        ScanReportPollerFrontEnd.assertNotNull(this.m_pollService, "pollService");
    }

    public void destroy() {
    }

    private void doRegister(String location) {
        this.m_location = location;
    }

    public static Map<String, String> getDetails() {
        HashMap<String, String> details = new HashMap<String, String>();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            if (!e.getKey().toString().startsWith("os.") || e.getValue() == null) continue;
            details.put(e.getKey().toString(), e.getValue().toString());
        }
        InetAddress us = InetAddressUtils.getLocalHostAddress();
        details.put("org.opennms.netmgt.poller.remote.hostAddress", InetAddressUtils.str((InetAddress)us));
        details.put("org.opennms.netmgt.poller.remote.hostName", us.getHostName());
        return Collections.unmodifiableMap(details);
    }

    @Override
    public String getMonitorName() {
        return null;
    }

    @Override
    public Collection<PolledService> getPolledServices() {
        return Arrays.asList(this.m_pollerConfiguration.getPolledServices());
    }

    @Override
    public List<ServicePollState> getPollerPollState() {
        return Collections.emptyList();
    }

    @Override
    public ServicePollState getServicePollState(int polledServiceId) {
        return null;
    }

    @Override
    public boolean isRegistered() {
        return this.m_state.isRegistered();
    }

    @Override
    public boolean isStarted() {
        return this.m_state.isStarted();
    }

    @Override
    public void pollService(Integer polledServiceId) {
        this.m_state.pollService(polledServiceId);
    }

    @Override
    public void register(String monitoringLocation) {
        this.m_state.register(monitoringLocation);
    }

    @Override
    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.remove(listener);
    }

    @Override
    public void removeServicePollStateChangedListener(ServicePollStateChangedListener listener) {
    }

    @Override
    public void setInitialPollTime(Integer polledServiceId, Date initialPollTime) {
    }

    public void setPollerBackEnd(PollerBackEnd backEnd) {
        this.m_backEnd = backEnd;
    }

    public void setTimeAdjustment(TimeAdjustment timeAdjustment) {
        this.m_timeAdjustment = timeAdjustment;
    }

    public void setPollService(PollService pollService) {
        this.m_pollService = pollService;
    }

    private static void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + ScanReportPollerFrontEnd.class.getName()));
    }

    private static boolean matchesApplications(PolledService service, Collection<String> applicationNames) {
        if (applicationNames == null || applicationNames.size() < 1) {
            return true;
        }
        for (String application : service.getApplications()) {
            if (!applicationNames.contains(application)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performServiceScans() {
        this.firePropertyChange(ScanReportProperties.percentageComplete.toString(), null, 0.0);
        ScanReport scanReport = new ScanReport();
        scanReport.setLocation(this.m_location);
        scanReport.setTimestamp(new Date());
        for (Map.Entry<String, String> entry : ScanReportPollerFrontEnd.getDetails().entrySet()) {
            scanReport.addProperty(entry);
        }
        for (Map.Entry<String, String> entry : this.m_metadata.entrySet()) {
            scanReport.addProperty(entry);
        }
        if (this.m_selectedApplications != null && this.m_selectedApplications.size() > 0) {
            scanReport.addProperty("applications", this.m_selectedApplications.stream().collect(Collectors.joining(", ")));
        }
        Log4j2StringAppender appender = Log4j2StringAppender.createAppender();
        appender.start();
        try {
            this.m_pollService.setServiceMonitorLocators(this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR));
            this.m_pollerConfiguration = this.retrieveLatestConfiguration();
            appender.addToLogger("", Level.DEBUG);
            Set<PolledService> polledServices = this.getPolledServices().stream().filter(s -> ScanReportPollerFrontEnd.matchesApplications(s, this.m_selectedApplications)).collect(Collectors.toSet());
            PolledService[] services = polledServices.toArray(POLLED_SERVICE_ARRAY);
            LOG.debug("Polling {} services.", (Object)services.length);
            for (int i = 0; i < services.length; ++i) {
                PolledService service = services[i];
                try {
                    PollStatus result = this.doPoll(service);
                    if (result == null) {
                        LOG.warn("Null poll result for service {}", (Object)service.getServiceId());
                    } else {
                        LOG.info(new ToStringBuilder((Object)this).append("statusName", (Object)result.getStatusName()).append("reason", (Object)result.getReason()).toString());
                        scanReport.addPollResult(new ScanReportPollResult(service.getSvcName(), service.getServiceId(), service.getNodeLabel(), Integer.valueOf(service.getNodeId()), service.getIpAddr(), result));
                    }
                }
                catch (Throwable e) {
                    LOG.error("Unexpected exception occurred while polling service ID {}", (Object)service.getServiceId(), (Object)e);
                    this.setState(new FatalExceptionOccurred(e));
                }
                this.firePropertyChange(ScanReportProperties.percentageComplete.toString(), null, (double)i / (double)services.length);
            }
        }
        catch (Throwable e) {
            LOG.error("Error while performing scan", e);
        }
        finally {
            appender.removeFromLogger("");
        }
        this.firePropertyChange(ScanReportProperties.percentageComplete.toString(), null, 1.0);
        scanReport.setLog(new ScanReportLog(scanReport.getId(), appender.getOutput()));
        LOG.debug("Returning scan report: {}", (Object)scanReport);
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.exitNecessary.toString(), null, scanReport);
    }

    private PollerConfiguration retrieveLatestConfiguration() {
        PollerConfiguration config = this.m_backEnd.getPollerConfigurationForLocation(this.m_location);
        this.m_timeAdjustment.setMasterTime(config.getServerTime());
        return config;
    }

    private PollStatus doPoll(PolledService polledService) {
        return this.m_pollService.poll(polledService);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (ScanReportPollerFrontEnd.nullSafeEquals(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.m_propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private static boolean nullSafeEquals(Object oldValue, Object newValue) {
        return oldValue == newValue ? true : ObjectUtils.nullSafeEquals((Object)oldValue, (Object)newValue);
    }

    private void setState(PollerFrontEndState newState) {
        boolean started = this.isStarted();
        boolean registered = this.isRegistered();
        this.m_state = newState;
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.started.toString(), started, this.isStarted());
        this.firePropertyChange(PollerFrontEnd.PollerFrontEndStates.registered.toString(), registered, this.isRegistered());
    }

    public void setMetadata(Map<String, String> metadata) {
        this.m_metadata = metadata;
    }

    public void setSelectedApplications(Set<String> applications) {
        this.m_selectedApplications = applications;
    }

    @Override
    public void checkConfig() {
    }

    @Override
    public void initialize() {
        this.m_state.initialize();
    }

    @Override
    public boolean isExitNecessary() {
        return false;
    }

    @Override
    public boolean isDisconnected() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void stop() {
    }

    private class Running
    extends PollerFrontEndState {
        private Running() {
        }

        @Override
        public boolean isRegistered() {
            return true;
        }

        @Override
        public boolean isStarted() {
            return true;
        }

        @Override
        public void pollService(Integer polledServiceId) {
        }
    }

    private class Registering
    extends PollerFrontEndState {
        private Registering() {
        }

        @Override
        public boolean isRegistered() {
            return false;
        }

        @Override
        public boolean isStarted() {
            return false;
        }

        @Override
        public void register(String location) {
            try {
                ScanReportPollerFrontEnd.this.doRegister(location);
                ScanReportPollerFrontEnd.this.setState(new Running());
                ScanReportPollerFrontEnd.this.performServiceScans();
            }
            catch (Throwable e) {
                LOG.warn("Unable to register.", e);
                ScanReportPollerFrontEnd.this.setState(new FatalExceptionOccurred(e));
            }
        }
    }

    private class Initial
    extends PollerFrontEndState {
        private Initial() {
        }

        @Override
        public void initialize() {
            ScanReportPollerFrontEnd.this.setState(new Registering());
        }

        @Override
        public boolean isRegistered() {
            return false;
        }

        @Override
        public boolean isStarted() {
            return false;
        }
    }

    public static enum ScanReportProperties {
        percentageComplete;

    }
}

