/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="String", category="OpenNMS", elementType="appender", printObject=true)
public class Log4j2StringAppender
extends AbstractOutputStreamAppender<ByteArrayOutputStreamManager> {
    private static final long serialVersionUID = -6024745534963187041L;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)LogManager.getContext((boolean)false);
    private static final Configuration LOGGER_CONTEXT_CONFIGURATION = LOGGER_CONTEXT.getConfiguration();

    private Log4j2StringAppender(String name, Filter filter, boolean ignoreExceptions, boolean immediateFlush) {
        this(name, (Layout<? extends Serializable>)PatternLayout.createDefaultLayout(), filter, ignoreExceptions, immediateFlush);
    }

    private Log4j2StringAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, (OutputStreamManager)new ByteArrayOutputStreamManager(layout));
    }

    @PluginFactory
    public static Log4j2StringAppender createAppender() {
        String name = Log4j2StringAppender.class.getName() + INSTANCE_COUNTER.getAndIncrement();
        return new Log4j2StringAppender(name, null, false, true);
    }

    public void addToLogger(String loggerName, Level level) {
        LoggerConfig loggerConfig = LOGGER_CONTEXT_CONFIGURATION.getLoggerConfig(loggerName);
        if (level.isLessSpecificThan(loggerConfig.getLevel())) {
            loggerConfig.setLevel(level);
        }
        loggerConfig.addAppender((Appender)this, level, null);
        LOGGER_CONTEXT.updateLoggers();
    }

    public void removeFromLogger(String loggerName) {
        LoggerConfig loggerConfig = LOGGER_CONTEXT_CONFIGURATION.getLoggerConfig(loggerName);
        loggerConfig.removeAppender(this.getName());
        LOGGER_CONTEXT.updateLoggers();
    }

    public String getOutput() {
        ((ByteArrayOutputStreamManager)this.getManager()).flush();
        return new String(((ByteArrayOutputStreamManager)this.getManager()).getByteArrayOutputStream().toByteArray());
    }

    public static class ByteArrayOutputStreamManager
    extends OutputStreamManager {
        protected ByteArrayOutputStreamManager(Layout<?> layout) {
            super((OutputStream)new ByteArrayOutputStream(), ByteArrayOutputStreamManager.class.getName(), layout, true);
        }

        public ByteArrayOutputStream getByteArrayOutputStream() {
            return (ByteArrayOutputStream)this.getOutputStream();
        }
    }
}

