/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.poller.DefaultServiceMonitorRegistry;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.TimeAdjustment;
import org.springframework.util.Assert;

public class DefaultPollService
implements PollService {
    private static final ServiceMonitorRegistry s_serviceMonitorRegistry = new DefaultServiceMonitorRegistry();
    private TimeAdjustment m_timeAdjustment;
    private Map<String, ServiceMonitor> m_monitors = null;

    public void setTimeAdjustment(TimeAdjustment timeAdjustment) {
        this.m_timeAdjustment = timeAdjustment;
    }

    @Override
    public void setServiceMonitorLocators(Collection<ServiceMonitorLocator> locators) {
        HashMap<String, ServiceMonitor> monitors = new HashMap<String, ServiceMonitor>();
        for (ServiceMonitorLocator locator : locators) {
            monitors.put(locator.getServiceName(), locator.getServiceMonitor(s_serviceMonitorRegistry));
        }
        this.m_monitors = monitors;
    }

    @Override
    public PollStatus poll(PolledService polledService) {
        ServiceMonitor monitor = this.getServiceMonitor(polledService);
        if (monitor == null) {
            return PollStatus.unknown((String)("No service monitor for service " + polledService.getSvcName()));
        }
        PollStatus result = monitor.poll((MonitoredService)polledService, polledService.getMonitorConfiguration());
        result.setTimestamp(this.m_timeAdjustment.adjustDateToMasterDate(result.getTimestamp()));
        return result;
    }

    private ServiceMonitor getServiceMonitor(PolledService polledService) {
        Assert.notNull(this.m_monitors, (String)"setServiceMonitorLocators must be called before any other operations");
        ServiceMonitor monitor = this.m_monitors.get(polledService.getSvcName());
        return monitor;
    }
}

