/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerTheme;
import org.opennms.netmgt.poller.remote.metadata.MetadataField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;

public class ExceptionProtectedPollerBackEnd
implements PollerBackEnd {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionProtectedPollerBackEnd.class);
    private PollerBackEnd m_delegate;

    public void setDelegate(PollerBackEnd delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public void checkForDisconnectedMonitors() {
        try {
            this.m_delegate.checkForDisconnectedMonitors();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public void configurationUpdated() {
        try {
            this.m_delegate.configurationUpdated();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public String getMonitorName(String locationMonitorId) {
        try {
            return this.m_delegate.getMonitorName(locationMonitorId);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public Collection<OnmsMonitoringLocation> getMonitoringLocations() {
        try {
            return this.m_delegate.getMonitoringLocations();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public PollerConfiguration getPollerConfiguration(String locationMonitorId) {
        try {
            return this.m_delegate.getPollerConfiguration(locationMonitorId);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public PollerConfiguration getPollerConfigurationForLocation(String location) {
        try {
            return this.m_delegate.getPollerConfigurationForLocation(location);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public Set<String> getApplicationsForLocation(String location) {
        try {
            return this.m_delegate.getApplicationsForLocation(location);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            return this.m_delegate.getServiceMonitorLocators(context);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(String locationMonitorId, Date currentConfigurationVersion) {
        try {
            return this.m_delegate.pollerCheckingIn(locationMonitorId, currentConfigurationVersion);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public boolean pollerStarting(String locationMonitorId, Map<String, String> pollerDetails) {
        try {
            return this.m_delegate.pollerStarting(locationMonitorId, pollerDetails);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public void pollerStopping(String locationMonitorId) {
        try {
            this.m_delegate.pollerStopping(locationMonitorId);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public String registerLocationMonitor(String monitoringLocationId) {
        try {
            return this.m_delegate.registerLocationMonitor(monitoringLocationId);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public void reportResult(String locationMonitorID, int serviceId, PollStatus status) {
        try {
            this.m_delegate.reportResult(locationMonitorID, serviceId, status);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        try {
            this.m_delegate.saveResponseTimeData(locationMonitor, monSvc, responseTime, pkg);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public void reportSingleScan(ScanReport report) {
        try {
            this.m_delegate.reportSingleScan(report);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public Set<MetadataField> getMetadataFields() {
        try {
            return this.m_delegate.getMetadataFields();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }

    @Override
    public PollerTheme getTheme() {
        try {
            return this.m_delegate.getTheme();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception thrown in remote poller backend.", t);
            throw new RemoteAccessException("Unexpected Exception Occurred on the server.", t);
        }
    }
}

