/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollJob;
import org.opennms.netmgt.poller.remote.PollJobDetail;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PolledServiceTrigger;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Poller
implements InitializingBean,
ConfigurationChangedListener,
PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(Poller.class);
    public static final String LOG4J_CATEGORY = "poller";
    private PollerFrontEnd m_pollerFrontEnd;
    private Scheduler m_scheduler;
    private long m_initialSpreadTime = 300000L;

    public void setPollerFrontEnd(PollerFrontEnd pollerFrontEnd) {
        this.m_pollerFrontEnd = pollerFrontEnd;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setInitialSpreadTime(long initialSpreadTime) {
        this.m_initialSpreadTime = initialSpreadTime;
    }

    public void afterPropertiesSet() throws Exception {
        Poller.assertNotNull(this.m_scheduler, "scheduler");
        Poller.assertNotNull(this.m_pollerFrontEnd, "pollerFrontEnd");
        this.m_pollerFrontEnd.addConfigurationChangedListener(this);
        this.m_pollerFrontEnd.addPropertyChangeListener(this);
        if (this.m_pollerFrontEnd.isStarted()) {
            this.schedulePolls();
        } else {
            LOG.debug("Poller not yet registered");
        }
    }

    private void unschedulePolls() throws Exception {
        if (this.m_scheduler.isShutdown()) {
            return;
        }
        for (String jobName : this.m_scheduler.getJobNames("pollJobGroup")) {
            this.m_scheduler.deleteJob(jobName, "pollJobGroup");
        }
    }

    private void schedulePolls() throws Exception {
        LOG.debug("Enter schedulePolls");
        Collection<PolledService> polledServices = this.m_pollerFrontEnd.getPolledServices();
        if (polledServices == null || polledServices.size() == 0) {
            LOG.warn("No polling scheduled.");
            LOG.debug("Exit schedulePolls");
            return;
        }
        long startTime = System.currentTimeMillis();
        long scheduleSpacing = this.m_initialSpreadTime / (long)polledServices.size();
        for (PolledService polledService : polledServices) {
            String jobName = polledService.toString();
            if (this.m_scheduler.deleteJob(jobName, "pollJobGroup")) {
                LOG.debug("Job for {} already scheduled.  Rescheduling", (Object)polledService);
            } else {
                LOG.debug("Scheduling job for {}", (Object)polledService);
            }
            Date initialPollTime = new Date(startTime);
            this.m_pollerFrontEnd.setInitialPollTime(polledService.getServiceId(), initialPollTime);
            PolledServiceTrigger pollTrigger = new PolledServiceTrigger(polledService);
            pollTrigger.setStartTime(initialPollTime);
            PollJobDetail jobDetail = new PollJobDetail(jobName, PollJob.class);
            jobDetail.setPolledService(polledService);
            jobDetail.setPollerFrontEnd(this.m_pollerFrontEnd);
            this.m_scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)pollTrigger);
            startTime += scheduleSpacing;
        }
        LOG.debug("Exit schedulePolls");
    }

    private static void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }

    @Override
    public void configurationChanged(PropertyChangeEvent e) {
        try {
            this.unschedulePolls();
            this.schedulePolls();
        }
        catch (Throwable ex) {
            LOG.error("Unable to schedule polls!", ex);
            throw new RuntimeException("Unable to schedule polls!");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                if (PollerFrontEnd.PollerFrontEndStates.paused.toString().equals(evt.getPropertyName()) || PollerFrontEnd.PollerFrontEndStates.disconnected.toString().equals(evt.getPropertyName()) || PollerFrontEnd.PollerFrontEndStates.exitNecessary.toString().equals(evt.getPropertyName())) {
                    this.unschedulePolls();
                }
            } else if (PollerFrontEnd.PollerFrontEndStates.paused.toString().equals(evt.getPropertyName())) {
                this.schedulePolls();
            } else if (PollerFrontEnd.PollerFrontEndStates.disconnected.toString().equals(evt.getPropertyName())) {
                this.schedulePolls();
            } else if (PollerFrontEnd.PollerFrontEndStates.started.toString().equals(evt.getPropertyName())) {
                this.unschedulePolls();
            }
        }
        catch (Throwable ex) {
            LOG.error("Unable to schedule polls!", ex);
            throw new RuntimeException("Unable to schedule polls!");
        }
    }
}

