/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.metadata;

import java.awt.Color;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.poller.remote.PollerTheme;
import org.opennms.netmgt.poller.remote.metadata.InetAddressValidator;
import org.opennms.netmgt.poller.remote.metadata.IntegerValidator;
import org.opennms.netmgt.poller.remote.metadata.MetadataField;
import org.opennms.netmgt.poller.remote.metadata.MetadataFieldReader;

public class MetadataFieldReaderTest {
    @Test
    public void testValidFields() throws Exception {
        Set fields = this.getReader("target/test-classes/metadata.properties").getMetadataFields();
        Assert.assertEquals((long)3L, (long)fields.size());
        Iterator i = fields.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        MetadataField field = (MetadataField)i.next();
        Assert.assertEquals((Object)"Foo", (Object)field.getDescription());
        Assert.assertNotNull((Object)field.getValidator());
        Assert.assertTrue((boolean)field.getValidator().getClass().equals(IntegerValidator.class));
        Assert.assertTrue((boolean)field.isRequired());
        Assert.assertTrue((boolean)i.hasNext());
        field = (MetadataField)i.next();
        Assert.assertEquals((Object)"Bar", (Object)field.getDescription());
        Assert.assertNotNull((Object)field.getValidator());
        Assert.assertTrue((boolean)field.getValidator().getClass().equals(InetAddressValidator.class));
        Assert.assertFalse((boolean)field.isRequired());
        Assert.assertTrue((boolean)i.hasNext());
        field = (MetadataField)i.next();
        Assert.assertEquals((Object)"Baz", (Object)field.getDescription());
        Assert.assertNull((Object)field.getValidator());
        Assert.assertTrue((boolean)field.isRequired());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test(expected=ClassNotFoundException.class)
    public void testInvalidValidator() throws Exception {
        this.getReader("target/test-classes/invalid-validator.properties").getMetadataFields();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingDescription() throws Exception {
        this.getReader("target/test-classes/missing-description.properties").getMetadataFields();
    }

    @Test
    public void testValidTheme() throws Exception {
        PollerTheme theme = this.getReader("target/test-classes/metadata.properties").getTheme();
        Assert.assertEquals((Object)"Foo", (Object)theme.getTitle());
        Assert.assertEquals((Object)new URL("http://blah/"), (Object)theme.getImage());
        Assert.assertEquals((Object)new Color(0xFFFFFF), (Object)theme.getForegroundColor());
        Assert.assertEquals((Object)new Color(0), (Object)theme.getBackgroundColor());
        Assert.assertEquals((Object)new Color(0xFF0000), (Object)theme.getDetailColor());
    }

    private MetadataFieldReader getReader(String propFile) throws URISyntaxException {
        File propertiesFile = new File(propFile);
        Assert.assertTrue((boolean)propertiesFile.exists());
        return new MetadataFieldReader(propertiesFile);
    }
}

