/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventWriter;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.support.ScanReportPollerFrontEnd;
import org.opennms.test.FileAnticipator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd-scanReport.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"})
@JUnitConfigurationEnvironment(systemProperties={"opennms.pollerBackend.monitorCheckInterval=500", "opennms.pollerBackend.disconnectedTimeout=3000"})
@JUnitTemporaryDatabase(dirtiesContext=false, tempDbClass=MockDatabase.class)
public class ScanReportPollerFrontEndIT
implements TemporaryDatabaseAware<MockDatabase>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ScanReportPollerFrontEndIT.class);
    @Autowired
    private DatabasePopulator m_populator;
    @Autowired
    private PollerFrontEnd m_frontEnd;
    @Autowired
    @Qualifier(value="backend")
    private PollerBackEnd m_backEnd;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    private static FileAnticipator m_fileAnticipator;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;
    private MockDatabase m_db;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        this.m_populator.populateDatabase();
        this.m_eventIpcManager.setEventWriter((EventWriter)this.m_db);
    }

    @Test
    public void testRegister() throws Exception {
        Assert.assertFalse((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)1L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems"));
        Assert.assertEquals((long)0L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystemsproperties"));
        Assert.assertTrue((String)"There were unexpected poll results", (0 == this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes") ? 1 : 0) != 0);
        this.m_frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(PollerFrontEnd.PollerFrontEndStates.exitNecessary.toString())) {
                    ScanReport report = (ScanReport)evt.getNewValue();
                    System.out.println("Finished scan: " + report);
                    ScanReportPollerFrontEndIT.this.m_backEnd.reportSingleScan(report);
                    Assert.assertEquals((long)2L, (long)ScanReportPollerFrontEndIT.this.getEventCount());
                    ScanReportPollerFrontEndIT.this.queryEvents();
                    Assert.assertEquals((Object)System.getProperty("os.arch"), (Object)ScanReportPollerFrontEndIT.this.m_jdbcTemplate.queryForObject("select propertyValue from scanreportproperties where scanreportid = ? and property = ?", String.class, new Object[]{report.getId(), "os.arch"}));
                    Assert.assertEquals((Object)System.getProperty("os.name"), (Object)ScanReportPollerFrontEndIT.this.m_jdbcTemplate.queryForObject("select propertyValue from scanreportproperties where scanreportid = ? and property = ?", String.class, new Object[]{report.getId(), "os.name"}));
                    Assert.assertEquals((Object)System.getProperty("os.version"), (Object)ScanReportPollerFrontEndIT.this.m_jdbcTemplate.queryForObject("select propertyValue from scanreportproperties where scanreportid = ? and property = ?", String.class, new Object[]{report.getId(), "os.version"}));
                    ScanReportPollerFrontEndIT.this.m_frontEnd.stop();
                }
            }
        });
        this.m_frontEnd.initialize();
        Assert.assertFalse((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)1L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems"));
        Assert.assertEquals((long)0L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystemsproperties"));
        Assert.assertTrue((String)"There were unexpected poll results", (0 == this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes") ? 1 : 0) != 0);
        this.m_frontEnd.register("RDU");
        Assert.assertTrue((String)"Front end not started!", (boolean)this.m_frontEnd.isStarted());
        Assert.assertTrue((boolean)this.m_frontEnd.isRegistered());
        ScanReportPollerFrontEnd cfr_ignored_0 = (ScanReportPollerFrontEnd)this.m_frontEnd;
        for (Map.Entry entry : ScanReportPollerFrontEnd.getDetails().entrySet()) {
            LOG.info("Front end detail: " + (String)entry.getKey() + " -> " + (String)entry.getValue());
        }
    }

    protected int getSpecificChangesCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes where systemid = ?", new Object[]{monitorId});
    }

    protected int getDisconnectedCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems where status=? and id=?", new Object[]{OnmsLocationMonitor.MonitorStatus.DISCONNECTED.toString(), monitorId});
    }

    protected int getMonitorCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems where id=?", new Object[]{monitorId});
    }

    protected int getEventCount() {
        return this.m_jdbcTemplate.queryForInt("select count(*) from events");
    }

    protected void queryEvents() {
        System.out.println(this.m_jdbcTemplate.queryForList("select * from events"));
    }
}

