/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.test.FileAnticipator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"})
@JUnitConfigurationEnvironment(systemProperties={"opennms.pollerBackend.monitorCheckInterval=500", "opennms.pollerBackend.disconnectedTimeout=3000"})
@JUnitTemporaryDatabase
public class PollerFrontEndIT
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PollerFrontEndIT.class);
    @Autowired
    private DatabasePopulator m_populator;
    @Autowired
    private PollerFrontEnd m_frontEnd;
    @Autowired
    private PollerSettings m_settings;
    private static FileAnticipator m_fileAnticipator;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeClass
    public static void setUpAnticipator() throws IOException {
        m_fileAnticipator = new FileAnticipator();
        String filename = m_fileAnticipator.expecting("remote-poller.configuration").getCanonicalPath().replace("+", "%2B");
        System.setProperty("opennms.poller.configuration.resource", "file://" + filename);
    }

    @AfterClass
    public static void tearDownAnticipator() throws Throwable {
        if (m_fileAnticipator.isInitialized()) {
            m_fileAnticipator.deleteExpected();
        }
        m_fileAnticipator.tearDown();
    }

    @Before
    public void setUp() throws Exception {
        this.m_populator.populateDatabase();
    }

    @Test
    public void testRegister() throws Exception {
        Assert.assertFalse((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)1L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems"));
        Assert.assertEquals((long)0L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystemsproperties"));
        Assert.assertTrue((String)"There were unexpected poll results", (0 == this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes") ? 1 : 0) != 0);
        this.m_frontEnd.register("RDU");
        Assert.assertTrue((boolean)this.m_frontEnd.isStarted());
        String monitorId = this.m_settings.getMonitoringSystemId();
        Assert.assertTrue((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)2L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems"));
        Assert.assertEquals((long)5L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystemsproperties where monitoringsystemid = ?", new Object[]{monitorId}));
        Assert.assertEquals((long)1L, (long)this.getMonitorCount(monitorId));
        Assert.assertEquals((Object)System.getProperty("os.name"), (Object)this.m_jdbcTemplate.queryForObject("select propertyValue from monitoringsystemsproperties where monitoringsystemid = ? and property = ?", String.class, new Object[]{monitorId, "os.name"}));
        long wait = 60000L;
        while (wait > 0L) {
            Thread.sleep(1000L);
            LOG.debug("wait = {}", (Object)(wait -= 1000L));
            if (this.getMonitorCount(monitorId) != 1 || this.getDisconnectedCount(monitorId) != 0 || this.getSpecificChangesCount(monitorId) <= 0) continue;
        }
        Assert.assertEquals((long)1L, (long)this.getMonitorCount(monitorId));
        Assert.assertEquals((long)0L, (long)this.getDisconnectedCount(monitorId));
        int changesCount = this.getSpecificChangesCount(monitorId);
        Assert.assertTrue((String)("Could not find any pollResults (changes = " + changesCount + ")"), (changesCount > 0 ? 1 : 0) != 0);
        this.m_frontEnd.stop();
    }

    protected int getSpecificChangesCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes where systemid = ?", new Object[]{monitorId});
    }

    protected int getDisconnectedCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems where status=? and id=?", new Object[]{OnmsLocationMonitor.MonitorStatus.DISCONNECTED.toString(), monitorId});
    }

    protected int getMonitorCount(String monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from monitoringsystems where id=?", new Object[]{monitorId});
    }
}

