/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.remote.support.DefaultPollerBackEnd;
import org.springframework.util.SerializationUtils;

public class DefaultPollerBackEndTest {
    @Test
    public void canConvertServiceParametersToSerializableMap() {
        Parameter paramWithStringValue = new Parameter();
        paramWithStringValue.setKey("a");
        paramWithStringValue.setValue("test");
        Parameter paramWithNullValue = new Parameter();
        paramWithNullValue.setKey("b");
        paramWithNullValue.setAnyObject(null);
        Parameter paramWithNonSerializableObject = new Parameter();
        paramWithNonSerializableObject.setKey("c");
        paramWithNonSerializableObject.setAnyObject((Object)new DefaultPollerBackEndTest());
        Service svc = new Service();
        svc.setParameters((List)Lists.newArrayList((Object[])new Parameter[]{paramWithStringValue, paramWithNullValue, paramWithNonSerializableObject}));
        SerializationUtils.serialize((Object)DefaultPollerBackEnd.getParameterMap((Service)svc));
    }

    @Test
    public void getParameterMapMarshallsPageSequenceParameters() {
        PageSequence ps = new PageSequence();
        Page page = new Page();
        page.setMethod("GET");
        page.setHttpVersion("1.1");
        page.setScheme("http");
        page.setHost("${ipaddr}");
        page.setDisableSslVerification("true");
        page.setPort(Integer.valueOf(7080));
        page.setPath("/Login.do");
        page.setSuccessMatch("w00t");
        page.setResponseRange("100-399");
        ps.addPage(page);
        Parameter paramWithPageSequenceValue = new Parameter();
        paramWithPageSequenceValue.setKey("psm");
        paramWithPageSequenceValue.setAnyObject((Object)ps);
        Service svc = new Service();
        svc.setParameters((List)Lists.newArrayList((Object[])new Parameter[]{paramWithPageSequenceValue}));
        Map params = DefaultPollerBackEnd.getParameterMap((Service)svc);
        PageSequence unmarshalledPs = (PageSequence)JaxbUtils.unmarshal(PageSequence.class, (String)((String)params.get("psm")));
        Assert.assertEquals((Object)ps, (Object)unmarshalledPs);
    }
}

