/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-exportedPollerBackEnd-http.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"})
@JUnitConfigurationEnvironment(systemProperties={"opennms.pollerBackend.monitorCheckInterval=500", "opennms.pollerBackend.disconnectedTimeout=3000", "opennms.pollerBackend.minimumConfigurationReloadInterval=300000"})
@JUnitTemporaryDatabase
public class PollerBackEndIT
implements InitializingBean {
    @Resource(name="daemon")
    PollerBackEnd m_backEnd;
    @Autowired
    SessionFactory m_sessionFactory;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    DistPollerDao m_distPollerDao;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    ServiceTypeDao m_serviceTypeDao;
    @Autowired
    MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    LocationMonitorDao m_locationMonitorDao;
    @Autowired
    RrdStrategy<?, ?> m_rrdStrategy;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        LocationDef location = new LocationDef("RDU", "East Coast", new String[0], new String[]{"example1"}, new String[0], "Research Triangle Park, NC", Float.valueOf(35.71575f), Float.valueOf(-79.16262f), Long.valueOf(1L), new String[]{"odd"});
        this.m_monitoringLocationDao.saveOrUpdate((Object)location);
    }

    @Test
    @Transactional
    public void testRegister() {
        Collection locations = this.m_backEnd.getMonitoringLocations();
        Assert.assertNotNull((String)"locations list should not be null", (Object)locations);
        Assert.assertFalse((String)"locations list should not be empty", (boolean)locations.isEmpty());
        int initialCount = this.m_locationMonitorDao.findAll().size();
        for (LocationDef location : locations) {
            String locationMonitorId = this.m_backEnd.registerLocationMonitor(location.getLocationName());
            Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.REGISTERED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
        }
        Assert.assertEquals((long)(initialCount + locations.size()), (long)this.m_locationMonitorDao.findAll().size());
    }

    @Test
    @Transactional
    public void testPollingStarted() {
        String locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId));
        Assert.assertNotNull((Object)monitor);
        Map details = monitor.getProperties();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)monitor.getStatus());
        Assert.assertEquals((long)2L, (long)details.keySet().size());
        Assert.assertEquals((Object)"WonkaOS", details.get("os.name"));
    }

    @Test
    @Transactional
    public void testPollingStopped() {
        String locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
        this.m_backEnd.pollerStopping(locationMonitorId);
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STOPPED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
    }

    @Test
    @Transactional
    public void testPollerDisconnected() throws Exception {
        String locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
        Thread.sleep(1500L);
        this.m_backEnd.checkForDisconnectedMonitors();
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
        Thread.sleep(2000L);
        this.m_backEnd.checkForDisconnectedMonitors();
        Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.DISCONNECTED, (Object)((OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)locationMonitorId))).getStatus());
    }

    @Test
    @Transactional
    public void testGetServiceMonitorLocators() {
        Collection results = this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    @Transactional
    public void testReportResults() throws InterruptedException {
        OnmsNode node = new OnmsNode("foo");
        OnmsIpInterface iface = new OnmsIpInterface(InetAddressUtils.addr((String)"192.168.1.1"), node);
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName("HTTP");
        if (serviceType == null) {
            serviceType = new OnmsServiceType("HTTP");
            this.m_serviceTypeDao.save((Object)serviceType);
            this.m_serviceTypeDao.flush();
        }
        OnmsMonitoredService service = new OnmsMonitoredService(iface, serviceType);
        iface.setMonitoredServices(Collections.singleton(service));
        this.m_nodeDao.save((Object)node);
        this.m_nodeDao.flush();
        String locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        int serviceId = service.getId();
        File rrdFile = new File("target/test-data/distributed/" + locationMonitorId + "/" + InetAddressUtils.str((InetAddress)iface.getIpAddress()) + "/http" + this.m_rrdStrategy.getDefaultFileExtension());
        if (rrdFile.exists()) {
            rrdFile.delete();
        }
        Assert.assertFalse((boolean)rrdFile.exists());
        this.m_backEnd.reportResult(locationMonitorId, serviceId, PollStatus.available((Double)1234.0));
        Thread.sleep(1000L);
        this.m_backEnd.reportResult(locationMonitorId, serviceId, PollStatus.unavailable());
        Collection statuses = this.m_locationMonitorDao.getStatusChangesForLocationBetween(new Date(0L), new Date(), "RDU");
        Assert.assertEquals((long)2L, (long)statuses.size());
        Iterator statusIterator = statuses.iterator();
        OnmsLocationSpecificStatus status1 = (OnmsLocationSpecificStatus)statusIterator.next();
        OnmsLocationSpecificStatus status2 = (OnmsLocationSpecificStatus)statusIterator.next();
        Assert.assertEquals((Object)1234.0, (Object)status1.getPollResult().getResponseTime());
        Assert.assertNull((Object)status2.getPollResult().getResponseTime());
        Assert.assertTrue((String)("rrd file doesn't exist at " + rrdFile.getAbsolutePath()), (boolean)rrdFile.exists());
    }

    public Map<String, String> getPollerDetails() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "WonkaOS");
        pollerDetails.put("os.version", "1.2.3");
        return pollerDetails;
    }
}

