/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.opennms.netmgt.config.DefaultServiceMonitorLocator;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.DefaultTimeAdjustment;
import org.opennms.netmgt.poller.remote.DemoPollerConfiguration;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.netmgt.poller.remote.ServicePollState;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedEvent;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedListener;
import org.opennms.netmgt.poller.remote.TimeAdjustment;
import org.opennms.netmgt.poller.remote.support.DefaultPollerFrontEnd;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.util.ObjectUtils;

public class PollerFrontEndTest
extends TestCase {
    private PollerBackEnd m_backEnd;
    private ConfigurationChangedListener m_configChangeListener;
    private DefaultPollerFrontEnd m_frontEnd;
    private EasyMockUtils m_mock = new EasyMockUtils();
    private DemoPollerConfiguration m_oldPollerConfiguration;
    private ServicePollStateChangedListener m_polledServiceListener;
    private DemoPollerConfiguration m_pollerConfiguration;
    private PollService m_pollService;
    private Integer m_registeredId;
    private PropertyChangeListener m_registrationListener;
    private PollStatus m_serviceStatus;
    private PollerSettings m_settings;
    private OnmsLocationMonitor.MonitorStatus m_oldStatus = OnmsLocationMonitor.MonitorStatus.STARTED;
    private OnmsLocationMonitor.MonitorStatus m_monitorStatus = OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;

    public void testAfterPropertiesSetWhenNotRegistered() throws Exception {
        this.testAfterPropertiesSetWithRegisteredId(null);
    }

    public void testAfterPropertiesSetWhenRegistered() throws Exception {
        this.testAfterPropertiesSetWithRegisteredId(1);
    }

    public void testAlreadyRegistered() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        PollerFrontEndTest.assertTrue((boolean)this.m_frontEnd.isRegistered());
        this.m_mock.verifyAll();
    }

    public void testConfigCheck() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.anticipateCheckConfig();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_frontEnd.checkConfig();
        this.m_mock.verifyAll();
    }

    public void testDetails() {
        Map details = this.m_frontEnd.getDetails();
        this.assertPropertyEquals("os.name", details);
        this.assertPropertyEquals("os.version", details);
    }

    public void testIsRegistered() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        PollerFrontEndTest.assertTrue((boolean)this.m_frontEnd.isRegistered());
        this.m_mock.verifyAll();
    }

    public void testNotYetRegistered() throws Exception {
        this.setRegisteredId(null);
        this.anticipateAfterPropertiesSet();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        PollerFrontEndTest.assertFalse((boolean)this.m_frontEnd.isRegistered());
        this.m_mock.verifyAll();
    }

    public void testPoll() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.anticipatePollService();
        this.anticipateGetServicePollState();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_frontEnd.pollService(Integer.valueOf(this.pollConfig().getFirstId()));
        ServicePollState pollState = this.m_frontEnd.getServicePollState(this.pollConfig().getFirstId());
        this.m_mock.verifyAll();
        PollerFrontEndTest.assertEquals((int)1, (int)pollState.getLastPoll().getStatusCode());
    }

    public void testRegisterNewMonitor() throws Exception {
        this.anticipateAfterPropertiesSet();
        this.anticiapateRegister();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        PollerFrontEndTest.assertFalse((boolean)this.m_frontEnd.isRegistered());
        this.m_frontEnd.register("OAK");
        PollerFrontEndTest.assertTrue((boolean)this.m_frontEnd.isRegistered());
        this.m_mock.verifyAll();
    }

    public void testSetInitialPollTime() throws Exception {
        Date start = new Date(1200000000000L);
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        int polledServiceId = this.pollConfig().getFirstId();
        this.anticipateSetInitialPollTime();
        this.anticipateGetServicePollState();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_frontEnd.setInitialPollTime(Integer.valueOf(polledServiceId), start);
        PollerFrontEndTest.assertEquals((Object)start, (Object)this.m_frontEnd.getServicePollState(polledServiceId).getNextPollTime());
        this.m_mock.verifyAll();
    }

    public void testStop() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.anticipateStop();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        PollerFrontEndTest.assertTrue((boolean)this.m_frontEnd.isStarted());
        this.m_frontEnd.stop();
        PollerFrontEndTest.assertFalse((boolean)this.m_frontEnd.isStarted());
        this.m_mock.verifyAll();
    }

    public void testPause() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.setMonitorStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        this.anticipateCheckConfig();
        this.setMonitorStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.anticipateCheckConfig();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_frontEnd.checkConfig();
        this.m_frontEnd.checkConfig();
        this.m_mock.verifyAll();
    }

    public void testDisconnect() throws Exception {
        this.setRegistered();
        this.anticipateAfterPropertiesSet();
        this.setMonitorStatus(OnmsLocationMonitor.MonitorStatus.DISCONNECTED);
        this.anticipateCheckConfig();
        this.setMonitorStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.anticipateCheckConfig();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_frontEnd.checkConfig();
        this.m_frontEnd.checkConfig();
        this.m_mock.verifyAll();
    }

    private void setMonitorStatus(OnmsLocationMonitor.MonitorStatus status) {
        this.m_oldStatus = this.m_monitorStatus;
        this.m_monitorStatus = status;
    }

    protected void setUp() throws Exception {
        this.m_backEnd = (PollerBackEnd)this.m_mock.createMock(PollerBackEnd.class);
        this.m_settings = (PollerSettings)this.m_mock.createMock(PollerSettings.class);
        this.m_pollService = (PollService)this.m_mock.createMock(PollService.class);
        this.m_registrationListener = (PropertyChangeListener)this.m_mock.createMock(PropertyChangeListener.class);
        this.m_polledServiceListener = (ServicePollStateChangedListener)this.m_mock.createMock(ServicePollStateChangedListener.class);
        this.m_configChangeListener = (ConfigurationChangedListener)this.m_mock.createMock(ConfigurationChangedListener.class);
        this.setPollConfig(new DemoPollerConfiguration());
        this.m_oldPollerConfiguration = null;
        this.m_frontEnd = new DefaultPollerFrontEnd();
        this.m_frontEnd.setTimeAdjustment((TimeAdjustment)new DefaultTimeAdjustment());
        this.m_frontEnd.setPollerBackEnd(this.m_backEnd);
        this.m_frontEnd.setPollerSettings(this.m_settings);
        this.m_frontEnd.setPollService(this.m_pollService);
        this.m_frontEnd.addConfigurationChangedListener(this.m_configChangeListener);
        this.m_frontEnd.addPropertyChangeListener(this.m_registrationListener);
        this.m_frontEnd.addServicePollStateChangedListener(this.m_polledServiceListener);
        this.m_serviceStatus = PollStatus.available((Double)1234.0);
    }

    private void anticiapateRegister() {
        this.anticipateRegisterLocationMonitor();
        this.anticipateDoPollerStart();
    }

    private void anticipateAfterPropertiesSet() {
        this.anticipateGetMonitorId();
        if (this.getRegisteredId() == null) {
            return;
        }
        this.anticipateDoPollerStart();
    }

    private void anticipateDoPollerStart() {
        this.anticipateGetMonitorId();
        this.anticipatePollerStarting();
        this.anticipateDoLoadConfig();
        this.anticipateFirePropertyChangeEvent("registered", false, true);
        this.anticipateFirePropertyChangeEvent("started", false, true);
    }

    private void anticipateDoLoadConfig() {
        this.anticipatePollServiceSetMonitorLocators();
        this.anticipateGetMonitorId();
        this.anticipateGetConfiguration();
        this.anticipatePolledServicesInitialized();
        this.anticipateFireConfigurationChangeEvent();
    }

    private void anticipatePollerStarting() {
        EasyMock.expect((Object)this.m_backEnd.pollerStarting(this.getRegisteredId().intValue(), this.getPollerDetails())).andReturn((Object)true);
    }

    private void anticipateCheckConfig() {
        this.anticipateDoCheckIn();
    }

    private void anticipateDoCheckIn() {
        this.anticipateGetMonitorId();
        this.anticipatePollerCheckingIn();
        switch (this.m_monitorStatus) {
            case CONFIG_CHANGED: {
                this.anticipateDoLoadConfig();
                break;
            }
            case PAUSED: {
                this.anticipateDoPause();
                break;
            }
            case DISCONNECTED: {
                this.anticipateDoDisconnect();
                break;
            }
            case STARTED: {
                if (this.m_oldStatus == OnmsLocationMonitor.MonitorStatus.PAUSED) {
                    this.anticipateDoResume();
                    break;
                }
                if (this.m_oldStatus != OnmsLocationMonitor.MonitorStatus.DISCONNECTED) break;
                this.anticipateReconnect();
            }
        }
    }

    private void anticipateReconnect() {
        this.anticipateDoLoadConfig();
        this.anticipateFirePropertyChangeEvent("disconnected", true, false);
    }

    private void anticipateDoDisconnect() {
        this.anticipateDoLoadConfig();
        this.anticipateFirePropertyChangeEvent("disconnected", false, true);
    }

    private void anticipateDoResume() {
        this.anticipateDoLoadConfig();
        this.anticipateFirePropertyChangeEvent("paused", true, false);
    }

    private void anticipateDoPause() {
        this.anticipateFirePropertyChangeEvent("paused", false, true);
    }

    private void anticipateDoPoll() {
        this.anticipateGetPolledService();
        EasyMock.expect((Object)this.m_pollService.poll(this.pollConfig().getFirstService())).andReturn((Object)this.m_serviceStatus);
    }

    private void anticipateFireConfigurationChangeEvent() {
        PropertyChangeEvent e = new PropertyChangeEvent(this.m_frontEnd, "configuration", this.oldConfig() == null ? null : this.oldConfig().getConfigurationTimestamp(), this.pollConfig() == null ? null : this.pollConfig().getConfigurationTimestamp());
        this.m_configChangeListener.configurationChanged(this.eq(e));
    }

    private void anticipateFirePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this.m_frontEnd, property, oldValue, newValue);
        this.m_registrationListener.propertyChange(this.eq(e));
    }

    private void anticipateFireServicePollStateChanged() {
        ServicePollStateChangedEvent e = new ServicePollStateChangedEvent(this.pollConfig().getFirstService(), 0);
        this.m_polledServiceListener.pollStateChange(this.eq(e));
    }

    private void anticipateGetConfiguration() {
        EasyMock.expect((Object)this.m_backEnd.getPollerConfiguration(1)).andReturn((Object)this.pollConfig());
    }

    private void anticipateGetMonitorId() {
        EasyMock.expect((Object)this.m_settings.getMonitorId()).andReturn((Object)this.getRegisteredId());
    }

    private void anticipateGetPolledService() {
        this.anticipateGetServicePollState();
    }

    private void anticipateGetServicePollState() {
    }

    private void anticipatePolledServicesInitialized() {
        this.m_pollService.initialize((PolledService)EasyMock.isA(PolledService.class));
        EasyMock.expectLastCall().times(this.pollConfig().getPolledServices().length);
    }

    private void anticipatePollerCheckingIn() {
        Date oldTimestamp = this.pollConfig().getConfigurationTimestamp();
        switch (this.m_monitorStatus) {
            case CONFIG_CHANGED: {
                this.setPollConfig(new DemoPollerConfiguration());
                break;
            }
            case DISCONNECTED: {
                this.setPollConfig(new DemoPollerConfiguration(new Date(0L)));
                break;
            }
            case STARTED: {
                if (this.m_oldStatus == OnmsLocationMonitor.MonitorStatus.STARTED) break;
                this.setPollConfig(new DemoPollerConfiguration());
            }
        }
        EasyMock.expect((Object)this.m_backEnd.pollerCheckingIn(1, oldTimestamp)).andReturn((Object)this.m_monitorStatus);
    }

    private void anticipatePollerStopping() {
        this.m_backEnd.pollerStopping(this.getRegisteredId().intValue());
    }

    private void anticipatePollService() {
        this.anticipateDoPoll();
        this.anticipateUpdateServicePollState();
        this.anticipateGetMonitorId();
        this.anticipateReportResult();
    }

    private void anticipatePollServiceSetMonitorLocators() {
        DefaultServiceMonitorLocator locator = new DefaultServiceMonitorLocator("HTTP", ServiceMonitor.class);
        Set<DefaultServiceMonitorLocator> locators = Collections.singleton(locator);
        EasyMock.expect((Object)this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR)).andReturn(locators);
        this.m_pollService.setServiceMonitorLocators(locators);
    }

    private void anticipateRegisterLocationMonitor() {
        this.setRegistered();
        EasyMock.expect((Object)this.m_backEnd.registerLocationMonitor("OAK")).andReturn((Object)this.getRegisteredId());
        this.m_settings.setMonitorId(this.getRegisteredId());
    }

    private void anticipateReportResult() {
        this.m_backEnd.reportResult(this.getRegisteredId().intValue(), this.pollConfig().getFirstId(), this.m_serviceStatus);
    }

    private void anticipateSetInitialPollTime() {
        this.anticipateGetServicePollState();
        this.anticipateFireServicePollStateChanged();
    }

    private void anticipateStop() {
        this.anticipateGetMonitorId();
        this.anticipatePollerStopping();
        this.anticipateFirePropertyChangeEvent(DefaultPollerFrontEnd.PollerFrontEndStates.started.toString(), true, false);
        this.anticipateFirePropertyChangeEvent(DefaultPollerFrontEnd.PollerFrontEndStates.exitNecessary.toString(), false, true);
    }

    private void anticipateUpdateServicePollState() {
        this.anticipateGetServicePollState();
        this.anticipateFireServicePollStateChanged();
    }

    private void assertPropertyEquals(String propertyName, Map<String, String> details) {
        PollerFrontEndTest.assertNotNull((String)("has " + propertyName), (Object)details.get(propertyName));
        PollerFrontEndTest.assertEquals((String)propertyName, (String)System.getProperty(propertyName), (String)details.get(propertyName));
    }

    private PropertyChangeEvent eq(PropertyChangeEvent e) {
        EasyMock.reportMatcher((IArgumentMatcher)new PropertyChangeEventEquals(e));
        return null;
    }

    private ServicePollStateChangedEvent eq(ServicePollStateChangedEvent e) {
        EasyMock.reportMatcher((IArgumentMatcher)new PolledServiceChangeEventEquals(e));
        return null;
    }

    private Map<String, String> getPollerDetails() {
        return this.m_frontEnd.getDetails();
    }

    private Integer getRegisteredId() {
        return this.m_registeredId;
    }

    private DemoPollerConfiguration oldConfig() {
        return this.m_oldPollerConfiguration;
    }

    private DemoPollerConfiguration pollConfig() {
        return this.m_pollerConfiguration;
    }

    private void setPollConfig(DemoPollerConfiguration pollerConfiguration) {
        this.m_oldPollerConfiguration = this.pollConfig();
        this.m_pollerConfiguration = pollerConfiguration;
    }

    private void setRegistered() {
        this.setRegisteredId(1);
    }

    private void setRegisteredId(Integer registeredId) {
        this.m_registeredId = registeredId;
    }

    private void testAfterPropertiesSetWithRegisteredId(Integer registeredId) throws Exception {
        this.setRegisteredId(registeredId);
        this.anticipateAfterPropertiesSet();
        this.m_mock.replayAll();
        this.m_frontEnd.afterPropertiesSet();
        this.m_mock.verifyAll();
    }

    public static class PropertyChangeEventEquals
    implements IArgumentMatcher {
        private PropertyChangeEvent m_expected;

        PropertyChangeEventEquals(PropertyChangeEvent value) {
            this.m_expected = value;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(this.m_expected);
            buffer.append(" property=");
            buffer.append(this.m_expected.getPropertyName());
            buffer.append(", oldValue=");
            buffer.append(this.m_expected.getOldValue());
            buffer.append(", newValue=");
            buffer.append(this.m_expected.getNewValue());
        }

        public boolean matches(Object argument) {
            PropertyChangeEvent actual = (PropertyChangeEvent)argument;
            if (this.m_expected == actual) {
                return true;
            }
            if (this.m_expected == null) {
                return actual == null;
            }
            return this.m_expected.getSource() == actual.getSource() && this.m_expected.getPropertyName().equals(actual.getPropertyName()) && ObjectUtils.nullSafeEquals((Object)this.m_expected.getOldValue(), (Object)actual.getOldValue()) && ObjectUtils.nullSafeEquals((Object)this.m_expected.getNewValue(), (Object)actual.getNewValue());
        }
    }

    public static class PolledServiceChangeEventEquals
    implements IArgumentMatcher {
        private ServicePollStateChangedEvent m_expected;

        PolledServiceChangeEventEquals(ServicePollStateChangedEvent value) {
            this.m_expected = value;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(this.m_expected);
        }

        public boolean matches(Object argument) {
            ServicePollStateChangedEvent actual = (ServicePollStateChangedEvent)argument;
            if (this.m_expected == null) {
                return actual == null;
            }
            return this.m_expected.getSource() == actual.getSource() && this.m_expected.getIndex() == actual.getIndex();
        }
    }
}

