/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.test.FileAnticipator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml"})
@JUnitConfigurationEnvironment(systemProperties={"opennms.pollerBackend.monitorCheckInterval=500", "opennms.pollerBackend.disconnectedTimeout=3000"})
@JUnitTemporaryDatabase
public class PollerFrontEndIntegrationTest
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PollerFrontEndIntegrationTest.class);
    @Autowired
    private DatabasePopulator m_populator;
    @Autowired
    private PollerFrontEnd m_frontEnd;
    @Autowired
    private PollerSettings m_settings;
    private static FileAnticipator m_fileAnticipator;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() throws Exception {
        this.m_populator.populateDatabase();
    }

    @Test
    @Ignore
    public void testRegister() throws Exception {
        Assert.assertFalse((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)0L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from location_monitors"));
        Assert.assertEquals((long)0L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from location_monitor_details"));
        Assert.assertTrue((String)"There were unexpected poll results", (0 == this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes") ? 1 : 0) != 0);
        this.m_frontEnd.register("RDU");
        Assert.assertTrue((boolean)this.m_frontEnd.isStarted());
        Integer monitorId = this.m_settings.getMonitorId();
        Assert.assertTrue((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)1L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from location_monitors"));
        Assert.assertEquals((long)5L, (long)this.m_jdbcTemplate.queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", new Object[]{monitorId}));
        Assert.assertEquals((long)1L, (long)this.getMonitorCount(monitorId));
        Assert.assertEquals((Object)System.getProperty("os.name"), (Object)this.m_jdbcTemplate.queryForObject("select propertyValue from location_monitor_details where locationMonitorId = ? and property = ?", String.class, new Object[]{monitorId, "os.name"}));
        long wait = 60000L;
        while (wait > 0L) {
            Thread.sleep(1000L);
            LOG.debug("wait = {}", (Object)(wait -= 1000L));
            if (this.getMonitorCount(monitorId) != 1 || this.getDisconnectedCount(monitorId) != 0 || this.getSpecificChangesCount(monitorId) <= 0) continue;
        }
        Assert.assertEquals((long)1L, (long)this.getMonitorCount(monitorId));
        Assert.assertEquals((long)0L, (long)this.getDisconnectedCount(monitorId));
        int changesCount = this.getSpecificChangesCount(monitorId);
        Assert.assertTrue((String)("Could not find any pollResults (changes = " + changesCount + ")"), (changesCount > 0 ? 1 : 0) != 0);
        this.m_frontEnd.stop();
    }

    protected int getSpecificChangesCount(Integer monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from location_specific_status_changes where locationMonitorId = ?", new Object[]{monitorId});
    }

    protected int getDisconnectedCount(Integer monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from location_monitors where status=? and id=?", new Object[]{OnmsLocationMonitor.MonitorStatus.DISCONNECTED.toString(), monitorId});
    }

    protected int getMonitorCount(Integer monitorId) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from location_monitors where id=?", new Object[]{monitorId});
    }
}

