/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollConfiguration;
import org.opennms.netmgt.poller.remote.PollJobDetail;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PolledServiceTrigger;
import org.opennms.netmgt.poller.remote.Poller;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public class PollerTest {
    @Test
    public void testSchedule() throws Exception {
        this.testSchedule(false, this.getMonitoredService());
    }

    @Test
    public void testReschedule() throws Exception {
        this.testSchedule(true, this.getMonitoredService());
    }

    @Test
    public void testIPv6Schedule() throws Exception {
        this.testSchedule(false, this.getIPv6MonitoredService());
    }

    @Test
    public void testIPv6Reschedule() throws Exception {
        this.testSchedule(true, this.getIPv6MonitoredService());
    }

    public void testSchedule(boolean reschedule, OnmsMonitoredService svc) throws Exception {
        Scheduler scheduler = (Scheduler)EasyMock.createMock(Scheduler.class);
        PollService pollService = (PollService)EasyMock.createNiceMock(PollService.class);
        PollerFrontEnd pollerFrontEnd = (PollerFrontEnd)EasyMock.createMock(PollerFrontEnd.class);
        svc.setId(Integer.valueOf(7));
        PollConfiguration pollConfig = new PollConfiguration(svc, new HashMap(), 300000L);
        PolledService polledService = new PolledService(pollConfig.getMonitoredService(), pollConfig.getMonitorConfiguration(), pollConfig.getPollModel());
        Set<PolledService> polledServices = Collections.singleton(polledService);
        Poller poller = new Poller();
        pollerFrontEnd.addConfigurationChangedListener((ConfigurationChangedListener)poller);
        pollerFrontEnd.addPropertyChangeListener((PropertyChangeListener)poller);
        EasyMock.expect((Object)pollerFrontEnd.getPolledServices()).andReturn(polledServices);
        EasyMock.expect((Object)pollerFrontEnd.isStarted()).andReturn((Object)true);
        EasyMock.expect((Object)scheduler.deleteJob(polledService.toString(), "pollJobGroup")).andReturn((Object)reschedule);
        pollerFrontEnd.setInitialPollTime((Integer)EasyMock.eq((Object)svc.getId()), (Date)EasyMock.isA(Date.class));
        EasyMock.expect((Object)scheduler.scheduleJob((JobDetail)EasyMock.isA(PollJobDetail.class), (Trigger)EasyMock.isA(PolledServiceTrigger.class))).andReturn((Object)new Date());
        EasyMock.replay((Object[])new Object[]{scheduler, pollService, pollerFrontEnd});
        poller.setScheduler(scheduler);
        poller.setPollerFrontEnd(pollerFrontEnd);
        poller.afterPropertiesSet();
        EasyMock.verify((Object[])new Object[]{scheduler, pollService, pollerFrontEnd});
    }

    private OnmsMonitoredService getMonitoredService() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.1", node);
        OnmsServiceType svcType = new OnmsServiceType("HTTP");
        OnmsMonitoredService svc = new OnmsMonitoredService(iface, svcType);
        return svc;
    }

    private OnmsMonitoredService getIPv6MonitoredService() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface("::1", node);
        Assert.assertEquals((Object)"0000:0000:0000:0000:0000:0000:0000:0001", (Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
        OnmsServiceType svcType = new OnmsServiceType("HTTP");
        OnmsMonitoredService svc = new OnmsMonitoredService(iface, svcType);
        return svc;
    }
}

