/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.util.Objects;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.utils.RpcTargetHelper;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.PollerRequestBuilder;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.opennms.netmgt.poller.client.rpc.PollerClientRpcModule;
import org.opennms.netmgt.poller.client.rpc.PollerRequestBuilderImpl;
import org.opennms.netmgt.poller.client.rpc.PollerRequestDTO;
import org.opennms.netmgt.poller.client.rpc.PollerResponseDTO;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationAwarePollerClientImpl
implements LocationAwarePollerClient,
InitializingBean {
    @Autowired
    private ServiceMonitorRegistry registry;
    @Autowired
    private PollerClientRpcModule pollerClientRpcModule;
    @Autowired
    private RpcClientFactory rpcClientFactory;
    @Autowired
    private RpcTargetHelper rpcTargetHelper;
    private RpcClient<PollerRequestDTO, PollerResponseDTO> delegate;

    public LocationAwarePollerClientImpl() {
    }

    public LocationAwarePollerClientImpl(RpcClientFactory rpcClientFactory) {
        this.rpcClientFactory = Objects.requireNonNull(rpcClientFactory);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.delegate = this.rpcClientFactory.getClient((RpcModule)this.pollerClientRpcModule);
    }

    protected RpcClient<PollerRequestDTO, PollerResponseDTO> getDelegate() {
        return this.delegate;
    }

    public PollerRequestBuilder poll() {
        return new PollerRequestBuilderImpl(this);
    }

    public ServiceMonitorRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceMonitorRegistry registry) {
        this.registry = registry;
    }

    public RpcTargetHelper getRpcTargetHelper() {
        return this.rpcTargetHelper;
    }

    public void setRpcTargetHelper(RpcTargetHelper rpcTargetHelper) {
        this.rpcTargetHelper = rpcTargetHelper;
    }
}

