/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.PollerRequest;
import org.opennms.netmgt.poller.client.rpc.PollerAttributeDTO;

@XmlRootElement(name="poller-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PollerRequestDTO
implements RpcRequest,
PollerRequest {
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="class-name")
    private String className;
    @XmlAttribute(name="service-name")
    private String serviceName;
    @XmlAttribute(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress address;
    @XmlAttribute(name="node-id")
    private Integer nodeId;
    @XmlAttribute(name="node-label")
    private String nodeLabel;
    @XmlAttribute(name="node-location")
    private String nodeLocation;
    @XmlElement(name="attribute")
    private List<PollerAttributeDTO> attributes = new ArrayList<PollerAttributeDTO>();
    private Long timeToLiveMs;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSvcName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getIpAddr() {
        return InetAddressUtils.str((InetAddress)this.address);
    }

    public int getNodeId() {
        return this.nodeId == null ? 0 : this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    public String getNodeLocation() {
        return this.nodeLocation;
    }

    public void setNodeLocation(String nodeLocation) {
        this.nodeLocation = nodeLocation;
    }

    public List<PollerAttributeDTO> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<PollerAttributeDTO> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String key, Object value) {
        this.attributes.add(new PollerAttributeDTO(key, value));
    }

    public void addAttributes(Map<String, Object> attributes) {
        attributes.entrySet().stream().forEach(e -> this.addAttribute((String)e.getKey(), e.getValue()));
    }

    public Map<String, Object> getMonitorParameters() {
        HashMap<String, Object> pollerAttributeMap = new HashMap<String, Object>();
        for (PollerAttributeDTO attribute : this.attributes) {
            if (attribute.getContents() != null) {
                pollerAttributeMap.put(attribute.getKey(), attribute.getContents());
                continue;
            }
            pollerAttributeMap.put(attribute.getKey(), attribute.getValue());
        }
        return pollerAttributeMap;
    }

    public void setTimeToLiveMs(Long timeToLiveMs) {
        this.timeToLiveMs = timeToLiveMs;
    }

    public Long getTimeToLiveMs() {
        return this.timeToLiveMs;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PollerRequestDTO)) {
            return false;
        }
        PollerRequestDTO castOther = (PollerRequestDTO)other;
        return Objects.equals(this.location, castOther.location) && Objects.equals(this.className, castOther.className) && Objects.equals(this.serviceName, castOther.serviceName) && Objects.equals(this.address, castOther.address) && Objects.equals(this.nodeId, castOther.nodeId) && Objects.equals(this.nodeLabel, castOther.nodeLabel) && Objects.equals(this.timeToLiveMs, castOther.timeToLiveMs) && Objects.equals(this.attributes, castOther.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.className, this.serviceName, this.address, this.nodeId, this.nodeLabel, this.attributes, this.timeToLiveMs);
    }
}

