/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.opennms.netmgt.poller.client.rpc.PollerRequestDTO;
import org.opennms.netmgt.poller.client.rpc.PollerResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PollerClientRpcModule
extends AbstractXmlRpcModule<PollerRequestDTO, PollerResponseDTO> {
    public static final String RPC_MODULE_ID = "Poller";
    @Autowired
    private ServiceMonitorRegistry serviceMonitorRegistry;
    @Autowired
    @Qualifier(value="pollerExecutor")
    private Executor executor;

    public PollerClientRpcModule() {
        super(PollerRequestDTO.class, PollerResponseDTO.class);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public CompletableFuture<PollerResponseDTO> execute(final PollerRequestDTO request) {
        String className = request.getClassName();
        final ServiceMonitor monitor = this.serviceMonitorRegistry.getMonitorByClassName(className);
        if (monitor == null) {
            return CompletableFuture.completedFuture(new PollerResponseDTO(PollStatus.unknown((String)("No monitor found with class name '" + className + "'."))));
        }
        return CompletableFuture.supplyAsync(new Supplier<PollerResponseDTO>(){

            @Override
            public PollerResponseDTO get() {
                PollStatus pollStatus;
                try {
                    Map<String, Object> parameters = request.getMonitorParameters();
                    pollStatus = monitor.poll((MonitoredService)request, parameters);
                }
                catch (RuntimeException e) {
                    pollStatus = PollStatus.unknown((String)e.getMessage());
                }
                return new PollerResponseDTO(pollStatus);
            }
        }, this.executor);
    }

    public void setServiceMonitorRegistry(ServiceMonitorRegistry serviceMonitorRegistry) {
        this.serviceMonitorRegistry = serviceMonitorRegistry;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

