/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceMonitorRegistry
implements ServiceMonitorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceMonitorRegistry.class);
    private static final String TYPE = "type";
    private static final ServiceLoader<ServiceMonitor> s_serviceMonitorLoader = ServiceLoader.load(ServiceMonitor.class);
    private final Map<String, ServiceMonitor> m_monitorsByClassName = new HashMap<String, ServiceMonitor>();

    public DefaultServiceMonitorRegistry() {
        for (ServiceMonitor serviceMonitor : s_serviceMonitorLoader) {
            HashMap<String, String> props = new HashMap<String, String>(1);
            props.put(TYPE, serviceMonitor.getClass().getCanonicalName());
            this.onBind(serviceMonitor, props);
        }
    }

    public synchronized void onBind(ServiceMonitor serviceMonitor, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)serviceMonitor, (Object)properties);
        if (serviceMonitor != null) {
            String className = DefaultServiceMonitorRegistry.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for monitor: {}, with properties: {}. The monitor will not be registered.", (Object)serviceMonitor, (Object)properties);
                return;
            }
            this.m_monitorsByClassName.put(className, serviceMonitor);
        }
    }

    public synchronized void onUnbind(ServiceMonitor serviceMonitor, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)serviceMonitor, (Object)properties);
        if (serviceMonitor != null) {
            String className = DefaultServiceMonitorRegistry.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for monitor: {}, with properties: {}. The monitor will not be unregistered.", (Object)serviceMonitor, (Object)properties);
                return;
            }
            this.m_monitorsByClassName.remove(className, serviceMonitor);
        }
    }

    @Override
    public ServiceMonitor getMonitorByClassName(String className) {
        return this.m_monitorsByClassName.get(className);
    }

    @Override
    public Set<String> getMonitorClassNames() {
        return Collections.unmodifiableSet(this.m_monitorsByClassName.keySet());
    }

    private static String getClassName(Map<?, ?> properties) {
        Object type = properties.get(TYPE);
        if (type != null && type instanceof String) {
            return (String)type;
        }
        return null;
    }
}

