/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class PollStatus
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final String PROPERTY_RESPONSE_TIME = "response-time";
    private Date m_timestamp = new Date();
    private int m_statusCode;
    private String m_reason;
    private Map<String, Number> m_properties = new LinkedHashMap<String, Number>();
    public static final int SERVICE_UNRESPONSIVE = 3;
    public static final int SERVICE_UNAVAILABLE = 2;
    public static final int SERVICE_AVAILABLE = 1;
    public static final int SERVICE_UNKNOWN = 0;
    private static final String[] s_statusNames = new String[]{"Unknown", "Up", "Down", "Unresponsive"};

    private static int decodeStatusName(String statusName) {
        for (int statusCode = 0; statusCode < s_statusNames.length; ++statusCode) {
            if (!s_statusNames[statusCode].equalsIgnoreCase(statusName)) continue;
            return statusCode;
        }
        return 0;
    }

    public static PollStatus decode(String statusName) {
        return PollStatus.decode(statusName, null, null);
    }

    public static PollStatus decode(String statusName, String reason) {
        return PollStatus.decode(statusName, reason, null);
    }

    public static PollStatus decode(String statusName, Double responseTime) {
        return PollStatus.decode(statusName, null, responseTime);
    }

    public static PollStatus decode(String statusName, String reason, Double responseTime) {
        return new PollStatus(PollStatus.decodeStatusName(statusName), reason, responseTime);
    }

    public static PollStatus get(int status, String reason) {
        return PollStatus.get(status, reason, null);
    }

    public static PollStatus get(int status, Double responseTime) {
        return PollStatus.get(status, null, responseTime);
    }

    public static PollStatus get(int status, String reason, Double responseTime) {
        return new PollStatus(status, reason, responseTime);
    }

    private PollStatus() {
        this(0, null, null);
    }

    private PollStatus(int statusCode, String reason, Double responseTime) {
        this.setStatusCode(statusCode);
        this.setReason(reason);
        this.setResponseTime(responseTime);
    }

    public static PollStatus up() {
        return PollStatus.up(null);
    }

    public static PollStatus up(Double responseTime) {
        return PollStatus.available(responseTime);
    }

    public static PollStatus available() {
        return PollStatus.available(null);
    }

    public static PollStatus available(Double responseTime) {
        return new PollStatus(1, null, responseTime);
    }

    public static PollStatus unknown() {
        return PollStatus.unknown(null);
    }

    public static PollStatus unknown(String reason) {
        return new PollStatus(0, reason, null);
    }

    public static PollStatus unresponsive() {
        return PollStatus.unresponsive(null);
    }

    public static PollStatus unresponsive(String reason) {
        return new PollStatus(3, reason, null);
    }

    public static PollStatus down() {
        return PollStatus.down(null);
    }

    public static PollStatus unavailable() {
        return PollStatus.unavailable(null);
    }

    public static PollStatus down(String reason) {
        return PollStatus.unavailable(reason);
    }

    public static PollStatus unavailable(String reason) {
        return new PollStatus(2, reason, null);
    }

    public boolean equals(Object o) {
        if (o instanceof PollStatus) {
            return this.m_statusCode == ((PollStatus)o).m_statusCode;
        }
        return false;
    }

    public int hashCode() {
        return this.m_statusCode;
    }

    @Transient
    public boolean isUp() {
        return !this.isDown();
    }

    @Transient
    public boolean isAvailable() {
        return this.m_statusCode == 1;
    }

    @Transient
    public boolean isUnresponsive() {
        return this.m_statusCode == 3;
    }

    @Transient
    public boolean isUnavailable() {
        return this.m_statusCode == 2;
    }

    @Transient
    public boolean isDown() {
        return this.m_statusCode == 2;
    }

    @Transient
    public boolean isUnknown() {
        return this.m_statusCode == 0;
    }

    public String toString() {
        return this.getStatusName();
    }

    @Column(name="statusTime", nullable=false)
    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    @Column(name="statusReason", nullable=true)
    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        this.m_reason = reason;
    }

    @Column(name="responseTime", nullable=true)
    public Double getResponseTime() {
        Number val = this.getProperty(PROPERTY_RESPONSE_TIME);
        return val == null ? null : Double.valueOf(val.doubleValue());
    }

    public void setResponseTime(Double responseTime) {
        if (responseTime == null) {
            this.m_properties.remove(PROPERTY_RESPONSE_TIME);
        } else {
            this.m_properties.put(PROPERTY_RESPONSE_TIME, responseTime);
        }
    }

    @Transient
    public Map<String, Number> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new LinkedHashMap<String, Number>();
        }
        return this.m_properties;
    }

    public void setProperties(Map<String, Number> p) {
        this.m_properties = p;
    }

    @Transient
    public Number getProperty(String key) {
        if (this.m_properties != null) {
            return this.m_properties.get(key);
        }
        return null;
    }

    public void setProperty(String key, Number value) {
        Map<String, Number> m = this.getProperties();
        m.put(key, value);
        this.setProperties(m);
    }

    @Column(name="statusCode", nullable=false)
    public int getStatusCode() {
        return this.m_statusCode;
    }

    private void setStatusCode(int statusCode) {
        this.m_statusCode = statusCode;
    }

    @Transient
    public String getStatusName() {
        return s_statusNames[this.m_statusCode];
    }
}

