/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.WSManVersion;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.wsman.Definition;
import org.opennms.netmgt.config.wsman.Range;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.config.wsman.WsmanConfig;
import org.opennms.netmgt.dao.WSManConfigDao;

public class WSManConfigDaoJaxb
extends AbstractJaxbConfigDao<WsmanConfig, WsmanConfig>
implements WSManConfigDao {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_PATH = "/wsman";

    public WSManConfigDaoJaxb() {
        super(WsmanConfig.class, "WS-Man Configuration");
    }

    @Override
    public WsmanConfig getConfig() {
        return (WsmanConfig)this.getContainer().getObject();
    }

    @Override
    public WsmanAgentConfig getConfig(InetAddress agentInetAddress) {
        Objects.requireNonNull(agentInetAddress);
        for (Definition def : this.getConfig().getDefinition()) {
            for (String saddr : def.getSpecific()) {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (!addr.equals(agentInetAddress)) continue;
                return def;
            }
            for (Range rng : def.getRange()) {
                if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                return def;
            }
            for (String ipMatch : def.getIpMatch()) {
                if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                return def;
            }
        }
        return this.getConfig();
    }

    @Override
    public WSManEndpoint getEndpoint(InetAddress agentInetAddress) {
        return this.getEndpoint(this.getConfig(agentInetAddress), agentInetAddress);
    }

    @Override
    public WSManEndpoint getEndpoint(WsmanAgentConfig agentConfig, InetAddress agentInetAddress) {
        URL url;
        Objects.requireNonNull(agentConfig, "agentConfig argument");
        Objects.requireNonNull(agentInetAddress, "agentInetAddress argument");
        try {
            String protocol = DEFAULT_PROTOCOL;
            if (agentConfig.isSsl() != null) {
                protocol = agentConfig.isSsl() != false ? "https" : DEFAULT_PROTOCOL;
            }
            String port = "";
            if (agentConfig.getPort() != null) {
                port = String.format(":%d", agentConfig.getPort());
            }
            String path = DEFAULT_PATH;
            if (agentConfig.getPath() != null) {
                path = agentConfig.getPath();
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            String host = agentInetAddress.getHostAddress();
            if (agentConfig.isGssAuth() != null && agentConfig.isGssAuth().booleanValue()) {
                host = agentInetAddress.getCanonicalHostName();
            }
            url = new URL(String.format("%s://%s%s%s", protocol, host, port, path));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid endpoint URL: " + e.getMessage());
        }
        WSManEndpoint.Builder builder = new WSManEndpoint.Builder(url).withServerVersion(WSManVersion.WSMAN_1_0);
        if (agentConfig.getUsername() != null && agentConfig.getPassword() != null) {
            builder.withBasicAuth(agentConfig.getUsername(), agentConfig.getPassword());
        }
        if (agentConfig.isGssAuth() != null && agentConfig.isGssAuth().booleanValue()) {
            builder.withGSSAuth();
        }
        if (agentConfig.getMaxElements() != null) {
            builder.withMaxElements(agentConfig.getMaxElements());
        }
        if (agentConfig.isStrictSsl() != null) {
            builder.withStrictSSL(false);
        }
        if (agentConfig.getTimeout() != null) {
            builder.withConnectionTimeout(agentConfig.getTimeout()).withReceiveTimeout(agentConfig.getTimeout());
        }
        return builder.build();
    }

    protected WsmanConfig translateConfig(WsmanConfig config) {
        return config;
    }
}

