/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wsman;

import java.io.Serializable;
import java.net.InetAddress;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.detector.wsman.WsManDetector;
import org.opennms.netmgt.provision.detector.wsman.WsmanEndpointUtils;
import org.opennms.netmgt.provision.support.DetectRequestImpl;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WsManDetectorFactory
extends GenericServiceDetectorFactory<WsManDetector> {
    private static final Logger LOG = LoggerFactory.getLogger(WsManDetectorFactory.class);
    private final WSManClientFactory m_factory = new CXFWSManClientFactory();
    @Autowired
    private WSManConfigDao m_wsmanConfigDao;
    @Autowired
    private NodeDao m_nodeDao;

    public WsManDetectorFactory() {
        super(WsManDetector.class);
    }

    public WsManDetector createDetector() {
        WsManDetector detector = new WsManDetector();
        detector.setClientFactory(this.m_factory);
        return detector;
    }

    public DetectRequest buildRequest(String location, InetAddress address, Integer port) {
        return new DetectRequestImpl(address, port, WsmanEndpointUtils.toMap(this.m_wsmanConfigDao.getEndpoint(address)));
    }

    @Transactional
    public void afterDetect(DetectRequest request, DetectResults results, Integer nodeId) {
        if (!results.isServiceDetected() || nodeId == null) {
            return;
        }
        boolean updateAssets = Boolean.parseBoolean(results.getServiceAttributes().getOrDefault("update-assests", "false"));
        String productVendor = (String)results.getServiceAttributes().get("product-vendor");
        String productVersion = (String)results.getServiceAttributes().get("product-version");
        if (!updateAssets) {
            LOG.info("Asset updates disabled.");
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        if (node == null) {
            LOG.warn("No node was found with id: {}", (Object)nodeId);
            return;
        }
        LOG.debug("Updating vendor and modelNumber assets on node[{}] with '{}' and '{}'", new Object[]{nodeId, productVendor, productVersion});
        node.getAssetRecord().setVendor(productVendor);
        node.getAssetRecord().setModelNumber(productVersion);
        this.m_nodeDao.update((Object)node);
    }
}

