/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.xml.AbstractMergingJaxbConfigDao;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.config.wsman.Collection;
import org.opennms.netmgt.config.wsman.Group;
import org.opennms.netmgt.config.wsman.SystemDefinition;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.config.wsman.WsmanDatacollectionConfig;
import org.opennms.netmgt.dao.WSManDataCollectionConfigDao;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class WSManDataCollectionConfigDaoJaxb
extends AbstractMergingJaxbConfigDao<WsmanDatacollectionConfig, WsmanDatacollectionConfig>
implements WSManDataCollectionConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(WSManDataCollectionConfigDaoJaxb.class);

    public WSManDataCollectionConfigDaoJaxb() {
        super(WsmanDatacollectionConfig.class, "WS-Man Data Collection Configuration", Paths.get("etc", "wsman-datacollection-config.xml"), Paths.get("etc", "wsman-datacollection.d"));
    }

    public WsmanDatacollectionConfig translateConfig(WsmanDatacollectionConfig config) {
        return config;
    }

    public WsmanDatacollectionConfig mergeConfigs(WsmanDatacollectionConfig source, WsmanDatacollectionConfig target) {
        if (target == null) {
            target = new WsmanDatacollectionConfig();
        }
        return target.merge(source);
    }

    @Override
    public WsmanDatacollectionConfig getConfig() {
        return (WsmanDatacollectionConfig)this.getObject();
    }

    @Override
    public Collection getCollectionByName(String name) {
        return this.getConfig().getCollection().stream().filter(c -> name.equals(c.getName())).findFirst().orElse(null);
    }

    @Override
    public List<Group> getGroupsForAgent(Collection collection, CollectionAgent agent, WsmanAgentConfig agentConfig, OnmsNode node) {
        List<SystemDefinition> sysDefs = this.getSystemDefinitionsForCollection(collection);
        ImmutableMap groupsByName = Maps.uniqueIndex(this.getConfig().getGroup(), g -> g.getName());
        ArrayList groups = Lists.newArrayList();
        for (SystemDefinition sysDef : sysDefs) {
            if (!WSManDataCollectionConfigDaoJaxb.isAgentSupportedBySystemDefinition(sysDef, agent, agentConfig, node)) continue;
            for (String groupName : sysDef.getIncludeGroup()) {
                Group group = (Group)groupsByName.get(groupName);
                if (group == null) {
                    LOG.warn("System definition with name {} includes group with name {}, but no such group was found.", (Object)sysDef.getName(), (Object)groupName);
                    continue;
                }
                groups.add(group);
            }
        }
        return groups;
    }

    public List<SystemDefinition> getSystemDefinitionsForCollection(Collection collection) {
        if (collection.getIncludeAllSystemDefinitions() != null) {
            return this.getConfig().getSystemDefinition();
        }
        ImmutableMap sysDefsByName = Maps.uniqueIndex(this.getConfig().getSystemDefinition(), sd -> sd.getName());
        ArrayList sysDefs = Lists.newArrayList();
        for (String sysDefName : collection.getIncludeSystemDefinition()) {
            SystemDefinition sysDef = (SystemDefinition)sysDefsByName.get(sysDefName);
            if (sysDef == null) {
                LOG.warn("Collection with name {} includes system definition with name {}, but no such definition was found.", (Object)collection.getName(), (Object)sysDefName);
                continue;
            }
            sysDefs.add(sysDef);
        }
        return sysDefs;
    }

    public static boolean isAgentSupportedBySystemDefinition(SystemDefinition sysDef, CollectionAgent agent, WsmanAgentConfig agentConfig, OnmsNode node) {
        String productVersion;
        String productVendor;
        if (agentConfig.getProductVendor() != null) {
            productVendor = agentConfig.getProductVendor();
        } else {
            productVendor = node.getAssetRecord().getVendor();
            productVendor = Strings.nullToEmpty((String)productVendor);
        }
        if (agentConfig.getProductVersion() != null) {
            productVersion = agentConfig.getProductVersion();
        } else {
            productVersion = node.getAssetRecord().getModelNumber();
            productVersion = Strings.nullToEmpty((String)productVersion);
        }
        StandardEvaluationContext context = new StandardEvaluationContext((Object)node);
        context.setVariable("agent", (Object)agent);
        context.setVariable("productVendor", (Object)productVendor);
        context.setVariable("productVersion", (Object)productVersion);
        for (String rule : sysDef.getRule()) {
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(rule);
            boolean passed = false;
            try {
                passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
            }
            catch (Exception e) {
                LOG.error("Failed to evaluate expression {} for agent {} with context {}. System defintion with name {} will not be used. Msg: {}", new Object[]{rule, agent, context, sysDef.getName(), e.getMessage()});
            }
            LOG.debug("Rule '{}' on {} passed? {}", new Object[]{rule, agent, passed});
            if (!passed) continue;
            return true;
        }
        return false;
    }
}

