/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wsman;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.wsman.Identity;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.PersistsAgentInfo;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class WsManDetector
extends SyncAbstractDetector
implements InitializingBean,
PersistsAgentInfo {
    public static final Logger LOG = LoggerFactory.getLogger(WsManDetector.class);
    private static final String PROTOCOL_NAME = "WS-Man";
    private final WSManClientFactory m_factory = new CXFWSManClientFactory();
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private final Map<InetAddress, Identity> m_identifyByInetAddress = Maps.newHashMap();
    @Autowired
    private WSManConfigDao m_wsmanConfigDao;
    @Autowired
    private NodeDao m_nodeDao;
    private boolean m_updateAssets = true;

    protected WsManDetector() {
        super(PROTOCOL_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isServiceDetected(InetAddress address) {
        WSManEndpoint endpoint = this.m_wsmanConfigDao.getEndpoint(address);
        WSManClient client = this.m_factory.getClient(endpoint);
        Identity identity = null;
        try {
            identity = client.identify();
            LOG.info("Identify succeeded for address {} with product vendor '{}' and product version '{}'.", new Object[]{address, identity.getProductVendor(), identity.getProductVersion()});
        }
        catch (WSManException e) {
            LOG.info("Identify failed for address {} with endpoint {}.", new Object[]{address, endpoint, e});
        }
        this.m_lock.writeLock().lock();
        try {
            this.m_identifyByInetAddress.put(address, identity);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        return identity != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void persistAgentInfo(Integer nodeId, InetAddress address) {
        if (!this.m_updateAssets) {
            LOG.debug("Asset updates disabled.");
            return;
        }
        Identity identity = null;
        this.m_lock.readLock().lock();
        try {
            identity = this.m_identifyByInetAddress.get(address);
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        if (identity == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        if (node == null) {
            LOG.warn("No node was found with id: {}", (Object)nodeId);
            return;
        }
        LOG.debug("Updating vendor and modelNumber assets on node[{}] with '{}' and '{}'", new Object[]{nodeId, identity.getProductVendor(), identity.getProductVersion()});
        node.getAssetRecord().setVendor(identity.getProductVendor());
        node.getAssetRecord().setModelNumber(identity.getProductVersion());
        this.m_nodeDao.update((Object)node);
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.m_wsmanConfigDao, "wsmanConfigDao attribute");
        Objects.requireNonNull(this.m_nodeDao, "nodeDao attribute");
    }

    protected void onInit() {
    }

    public void dispose() {
    }

    public void setUpdateAssets(boolean updateAssets) {
        this.m_updateAssets = updateAssets;
    }

    public boolean getUpdateAssets() {
        return this.m_updateAssets;
    }
}

