/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseHandlingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHandlingUtils.class);

    public static ListMultimap<String, String> toMultiMap(Node node) {
        ArrayListMultimap elementValues = ArrayListMultimap.create();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getLocalName() == null || child.getTextContent() == null) continue;
            elementValues.put((Object)child.getLocalName(), (Object)child.getTextContent());
        }
        return elementValues;
    }

    public static int getMatchingIndex(String spelExpression, ListMultimap<String, String> values) throws NoSuchElementException {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(spelExpression);
        return ResponseHandlingUtils.getMatchingIndex(exp, values, 0);
    }

    private static int getMatchingIndex(Expression exp, ListMultimap<String, String> valuesByName, int depth) throws NoSuchElementException {
        StandardEvaluationContext context = new StandardEvaluationContext();
        int maxDepth = 0;
        for (String name : valuesByName.keySet()) {
            List values = valuesByName.get((Object)name);
            maxDepth = Math.max(maxDepth, values.size());
            if (values.size() < depth + 1) continue;
            context.setVariable(name, values.get(depth));
        }
        try {
            if (((Boolean)exp.getValue((EvaluationContext)context, Boolean.class)).booleanValue()) {
                return depth;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to evaluate expression {}. Msg: {}", (Object)exp.getExpressionString(), (Object)e.getMessage());
            throw new NoSuchElementException();
        }
        if (maxDepth > depth) {
            return ResponseHandlingUtils.getMatchingIndex(exp, valuesByName, depth + 1);
        }
        throw new NoSuchElementException();
    }
}

