/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.core.wsman.utils.ResponseHandlingUtils;
import org.opennms.core.wsman.utils.RetryNTimesLoop;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class WsManMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(WsManMonitor.class);
    public static final String RESOURCE_URI_PARAM = "resource-uri";
    public static final String RULE_PARAM = "rule";
    public static final String SELECTOR_PARAM_PREFIX = "selector.";
    private WSManClientFactory m_factory = new CXFWSManClientFactory();
    private WSManConfigDao m_wsManConfigDao;

    @Override
    public void initialize(Map<String, Object> parameters) {
        LOG.debug("initialize({})", parameters);
        this.m_wsManConfigDao = (WSManConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManConfigDao", WSManConfigDao.class);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String resourceUri = WsManMonitor.getKeyedString(parameters, RESOURCE_URI_PARAM, null);
        if (resourceUri == null) {
            throw new IllegalArgumentException("'resource-uri' parameter is required.");
        }
        String rule = WsManMonitor.getKeyedString(parameters, RULE_PARAM, null);
        if (rule == null) {
            throw new IllegalArgumentException("'rule' parameter is required.");
        }
        HashMap selectors = Maps.newHashMap();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (!parameter.getKey().startsWith(SELECTOR_PARAM_PREFIX)) continue;
            String selectorKey = parameter.getKey().substring(SELECTOR_PARAM_PREFIX.length());
            Object selectorValue = parameter.getValue();
            if (selectorValue == null) continue;
            selectors.put(selectorKey, selectorValue instanceof String ? (String)selectorValue : selectorValue.toString());
        }
        WsmanAgentConfig config = this.m_wsManConfigDao.getConfig(svc.getAddress());
        WSManEndpoint endpoint = this.m_wsManConfigDao.getEndpoint(config, svc.getAddress());
        WSManClient client = this.m_factory.getClient(endpoint);
        RetryNTimesLoop retryLoop = new RetryNTimesLoop(config.getRetry() != null ? config.getRetry() : 0);
        Node node = null;
        try {
            while (retryLoop.shouldContinue()) {
                try {
                    node = client.get(resourceUri, (Map)selectors);
                    break;
                }
                catch (WSManException e) {
                    retryLoop.takeException(e);
                }
            }
        }
        catch (WSManException e) {
            return PollStatus.down((String)e.getMessage());
        }
        if (node == null) {
            return PollStatus.down((String)String.format("No resource was found at URI: '%s' with selectors: '%s'.", resourceUri, selectors));
        }
        ListMultimap<String, String> elementValues = ResponseHandlingUtils.toMultiMap(node);
        try {
            ResponseHandlingUtils.getMatchingIndex(rule, elementValues);
            return PollStatus.up();
        }
        catch (NoSuchElementException e) {
            return PollStatus.down((String)String.format("No index was matched by rule: '%s' with values '%s'.", rule, elementValues));
        }
    }

    public void setWSManConfigDao(WSManConfigDao wsManConfigDao) {
        this.m_wsManConfigDao = Objects.requireNonNull(wsManConfigDao);
    }

    public void setWSManClientFactory(WSManClientFactory factory) {
        this.m_factory = Objects.requireNonNull(factory);
    }
}

