/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import com.google.common.cache.CacheLoader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.core.cache.CacheConfig;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.persistence.MetaTagDataLoader;
import org.opennms.netmgt.timeseries.integration.persistence.TimeseriesPersister;
import org.opennms.newts.api.Context;

public class TimeseriesPersisterFactory
implements PersisterFactory {
    private final TimeseriesWriter timeseriesWriter;
    private final Context context;
    private final MetaTagDataLoader metaTagDataLoader;
    private final Cache<ResourcePath, Map<String, String>> metaCache;

    @Inject
    public TimeseriesPersisterFactory(Context context, TimeseriesWriter timeseriesWriter, MetaTagDataLoader metaTagDataLoader, CacheConfig cacheConfig) {
        this.context = Objects.requireNonNull(context);
        this.timeseriesWriter = timeseriesWriter;
        this.metaTagDataLoader = metaTagDataLoader;
        this.metaCache = new CacheBuilder().withConfig(cacheConfig).withCacheLoader((CacheLoader)metaTagDataLoader).build();
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return this.createPersister(params, repository, false, false, false);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        TimeseriesPersister persister = new TimeseriesPersister(params, repository, this.timeseriesWriter, this.context, this.metaTagDataLoader, this.metaCache);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }
}

