/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.cache.Cache;
import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.persistence.MetaTagDataLoader;
import org.opennms.netmgt.timeseries.integration.persistence.TimeseriesPersistOperationBuilder;
import org.opennms.newts.api.Context;

public class TimeseriesPersister
extends AbstractPersister {
    private final RrdRepository repository;
    private final TimeseriesWriter writer;
    private final Context context;
    private final MetaTagDataLoader metaDataLoader;
    private final Cache<ResourcePath, Map<String, String>> metaTagsByResourceCache;
    private TimeseriesPersistOperationBuilder builder;

    protected TimeseriesPersister(ServiceParameters params, RrdRepository repository, TimeseriesWriter timeseriesWriter, Context context, MetaTagDataLoader metaDataLoader, Cache<ResourcePath, Map<String, String>> metaTagsByResourceCache) {
        super(params, repository);
        this.repository = repository;
        this.writer = timeseriesWriter;
        this.context = context;
        this.metaDataLoader = metaDataLoader;
        this.metaTagsByResourceCache = metaTagsByResourceCache;
    }

    public void visitResource(CollectionResource resource) {
        super.visitResource(resource);
        this.metaTagsByResourceCache.put((Object)resource.getPath(), this.metaDataLoader.load(resource));
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            CollectionResource resource = group.getResource();
            Map<String, String> metaTags = this.getMetaTags(resource);
            this.builder = new TimeseriesPersistOperationBuilder(this.writer, this.context, this.repository, (ResourceIdentifier)resource, group.getName(), metaTags);
            if (resource.getTimeKeeper() != null) {
                this.builder.setTimeKeeper(resource.getTimeKeeper());
            }
            this.setBuilder(this.builder);
        }
    }

    private Map<String, String> getMetaTags(CollectionResource resource) {
        try {
            return (Map)this.metaTagsByResourceCache.get((Object)resource.getPath());
        }
        catch (ExecutionException e) {
            LOG.warn("An exception occurred while trying to retrieve meta tags for {}", (Object)resource.getPath(), (Object)e);
            return Collections.emptyMap();
        }
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) throws PersistException {
        this.builder.persistStringAttribute(path, key, value);
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

