/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Interpolator;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.timeseries.integration.MetaTagConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTagDataLoader
extends CacheLoader<CollectionResource, Map<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTagDataLoader.class);
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;
    private final EntityScopeProvider entityScopeProvider;
    private MetaTagConfiguration config;

    @Inject
    public MetaTagDataLoader(NodeDao nodeDao, SessionUtils sessionUtils, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao, "nodeDao must not be null");
        this.sessionUtils = Objects.requireNonNull(sessionUtils, "sessionUtils must not be null");
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider, "entityScopeProvider must not be null");
        this.setConfig(new MetaTagConfiguration((Map<String, String>)Maps.fromProperties((Properties)System.getProperties())));
    }

    public void setConfig(MetaTagConfiguration config) {
        this.config = config;
    }

    public Map<String, String> load(CollectionResource resource) {
        return (Map)this.sessionUtils.withReadOnlyTransaction(() -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            String nodeCriteria = this.getNodeCriteriaFromResource(resource);
            Optional<OnmsNode> nodeOptional = this.getNode(nodeCriteria);
            if (nodeOptional.isPresent()) {
                OnmsNode node = nodeOptional.get();
                scopes.add(this.entityScopeProvider.getScopeForNode(node.getId()));
                if (resource.getResourceTypeName().equals("if")) {
                    try {
                        int ifIndex = Integer.parseInt(resource.getInstance());
                        scopes.add(this.entityScopeProvider.getScopeForInterfaceByIfIndex(node.getId(), ifIndex));
                    }
                    catch (NumberFormatException ifIndex) {
                        // empty catch block
                    }
                }
            }
            FallbackScope scope = new FallbackScope(scopes);
            Map<String, String> configuredMetaTags = this.config.getConfiguredMetaTags();
            for (Map.Entry<String, String> entry : configuredMetaTags.entrySet()) {
                String value = Interpolator.interpolate((String)entry.getValue(), (Scope)scope);
                if (Strings.isNullOrEmpty((String)value)) continue;
                tags.put(entry.getKey(), value);
            }
            nodeOptional.ifPresent(onmsNode -> this.mapCategories((Map<String, String>)tags, (OnmsNode)onmsNode));
            return tags;
        });
    }

    private void mapCategories(Map<String, String> tags, OnmsNode node) {
        Objects.requireNonNull(node);
        if (this.config.isCategoriesEnabled()) {
            node.getCategories().stream().map(OnmsCategory::getName).forEach(catName -> tags.put("cat_" + catName, (String)catName));
        }
    }

    private Optional<OnmsNode> getNode(String nodeCriteria) {
        if (nodeCriteria == null || nodeCriteria.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.nodeDao.get(nodeCriteria));
        }
        catch (Exception e) {
            LOG.error("Error while trying to load node for criteria: {}. No node will be returned.", (Object)nodeCriteria, (Object)e);
            return Optional.empty();
        }
    }

    private String getNodeCriteriaFromResource(CollectionResource resource) {
        String nodeCriteria = null;
        if (resource.getParent() != null) {
            String[] resourcePathArray = resource.getParent().elements();
            if ("fs".equals(resourcePathArray[0]) && resourcePathArray.length == 3) {
                nodeCriteria = resourcePathArray[1] + ":" + resourcePathArray[2];
            } else if (this.checkNumeric(resourcePathArray[0])) {
                nodeCriteria = resourcePathArray[0];
            }
        }
        return nodeCriteria;
    }

    private boolean checkNumeric(String nodeCriteria) {
        try {
            Integer.parseInt(nodeCriteria);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

