/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.meta;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.timeseries.integration.support.TimeseriesUtils;
import org.opennms.netmgt.timeseries.meta.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesMetaDataDao {
    private static final Logger LOG = LoggerFactory.getLogger(TimeSeriesMetaDataDao.class);
    private final DataSource dataSource;
    private final Map<String, Map<String, String>> cache;

    @Autowired
    public TimeSeriesMetaDataDao(DataSource dataSource, @Named(value="timeseries.metadata.cache_size") long cacheSize, @Named(value="timeseries.metadata.cache_duration") long cacheDuration) {
        this.dataSource = dataSource;
        Cache cache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(cacheDuration, TimeUnit.SECONDS).build();
        this.cache = cache.asMap();
    }

    public void store(Collection<MetaData> metaDataCollection) throws SQLException {
        Objects.requireNonNull(metaDataCollection);
        HashSet<MetaData> uncached = new HashSet<MetaData>();
        for (MetaData meta : metaDataCollection) {
            if (Optional.ofNullable(this.cache.get(meta.getResourceId())).map(entry -> (String)entry.get(meta.getName())).isPresent()) continue;
            uncached.add(meta);
        }
        this.storeUncached(uncached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUncached(Collection<MetaData> metaDataCollection) throws SQLException {
        Objects.requireNonNull(metaDataCollection);
        String sql = "INSERT INTO timeseries_meta(resourceid, name, value)  values (?, ?, ?) ON CONFLICT (resourceid, name) DO UPDATE SET value=?";
        DBUtils db = new DBUtils(this.getClass());
        try {
            Connection connection = this.dataSource.getConnection();
            db.watch((Object)connection);
            PreparedStatement ps = connection.prepareStatement("INSERT INTO timeseries_meta(resourceid, name, value)  values (?, ?, ?) ON CONFLICT (resourceid, name) DO UPDATE SET value=?");
            db.watch((Object)ps);
            LOG.debug("Inserting {} attributes", (Object)metaDataCollection.size());
            for (MetaData metaData : metaDataCollection) {
                ps.setString(1, metaData.getResourceId());
                ps.setString(2, metaData.getName());
                ps.setString(3, metaData.getValue());
                ps.setString(4, metaData.getValue());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            db.cleanUp();
        }
    }

    public Map<String, String> getForResourcePath(ResourcePath path) throws StorageException {
        HashMap<String, String> metaData;
        Objects.requireNonNull(path);
        String resourceId = TimeseriesUtils.toResourceId(path);
        Map<String, String> cachedEntry = this.cache.get(resourceId);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        DBUtils db = new DBUtils(this.getClass());
        try {
            String sql = "SELECT name, value FROM timeseries_meta where resourceid = ?";
            Connection connection = this.dataSource.getConnection();
            db.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement(sql);
            db.watch((Object)statement);
            statement.setString(1, TimeseriesUtils.toResourceId(path));
            ResultSet rs = statement.executeQuery();
            db.watch((Object)rs);
            metaData = new HashMap<String, String>();
            while (rs.next()) {
                String name = rs.getString("name");
                String value = rs.getString("value");
                metaData.put(name, value);
            }
        }
        catch (SQLException e) {
            LOG.error("Could not retrieve meta data for resourceId={}", (Object)resourceId, (Object)e);
            throw new StorageException((Throwable)e);
        }
        finally {
            db.cleanUp();
        }
        this.cache.put(resourceId, metaData);
        return metaData;
    }
}

