/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import java.util.Objects;
import javax.inject.Inject;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.persistence.TimeseriesPersister;
import org.opennms.newts.api.Context;

public class TimeseriesPersisterFactory
implements PersisterFactory {
    private final TimeseriesWriter timeseriesWriter;
    private final Context context;

    @Inject
    public TimeseriesPersisterFactory(Context context, TimeseriesWriter timeseriesWriter) {
        this.context = Objects.requireNonNull(context);
        this.timeseriesWriter = timeseriesWriter;
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return this.createPersister(params, repository, false, false, false);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        TimeseriesPersister persister = new TimeseriesPersister(params, repository, this.timeseriesWriter, this.context);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }
}

