/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.support.TimeseriesUtils;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesPersistOperationBuilder
implements PersistOperationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesPersistOperationBuilder.class);
    private final TimeseriesWriter writer;
    private final RrdRepository rrepository;
    private final Context context;
    private final String name;
    private final ResourceIdentifier resource;
    private final Map<CollectionAttributeType, Number> declarations = Maps.newLinkedHashMap();
    private final Map<String, String> metaData = Maps.newLinkedHashMap();
    private final Map<ResourcePath, Map<String, String>> stringAttributesByPath = Maps.newLinkedHashMap();
    private TimeKeeper timeKeeper = new DefaultTimeKeeper();

    public TimeseriesPersistOperationBuilder(TimeseriesWriter writer, Context context, RrdRepository repository, ResourceIdentifier resource, String name) {
        this.writer = writer;
        this.context = context;
        this.rrepository = repository;
        this.resource = resource;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributeValue(CollectionAttributeType attributeType, Number value) {
        this.declarations.put(attributeType, value);
    }

    public void persistStringAttribute(ResourcePath path, String key, String value) {
        LinkedHashMap stringAttributesForPath = this.stringAttributesByPath.get(path);
        if (stringAttributesForPath == null) {
            stringAttributesForPath = Maps.newLinkedHashMap();
            this.stringAttributesByPath.put(path, stringAttributesForPath);
        }
        stringAttributesForPath.put(key, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        if (metricIdentifier == null) {
            if (name == null) {
                LOG.warn("Cannot set attribute metadata with null key and null value");
            } else {
                LOG.warn("Cannot set attribute metadata with null key and value of: {}", (Object)name);
            }
        } else {
            this.metaData.put(metricIdentifier, name);
        }
    }

    public void commit() throws PersistException {
        this.writer.insert(this.getSamplesToInsert());
        this.writer.index(this.getSamplesToIndex());
    }

    public List<Sample> getSamplesToInsert() {
        LinkedList samples = Lists.newLinkedList();
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.rrepository, (ResourcePath)ResourcePath.get((ResourcePath)this.resource.getPath(), (String[])new String[]{this.name}));
        TimeseriesUtils.addIndicesToAttributes(path, this.metaData);
        Resource resource = new Resource(TimeseriesUtils.toResourceId(path), Optional.of(this.metaData));
        Timestamp timestamp = Timestamp.fromEpochMillis((long)this.timeKeeper.getCurrentTime());
        for (Map.Entry<CollectionAttributeType, Number> entry : this.declarations.entrySet()) {
            Number value;
            CollectionAttributeType attrType = entry.getKey();
            MetricType type = TimeseriesPersistOperationBuilder.mapType(attrType.getType());
            if (type == null || (value = entry.getValue()) == null) continue;
            samples.add(new Sample(timestamp, this.context, resource, attrType.getName(), type, ValueType.compose((Number)entry.getValue(), (MetricType)type)));
        }
        return samples;
    }

    public List<Sample> getSamplesToIndex() {
        LinkedList samples = Lists.newLinkedList();
        for (Map.Entry<ResourcePath, Map<String, String>> entry : this.stringAttributesByPath.entrySet()) {
            Resource resource = new Resource(TimeseriesUtils.toResourceId(entry.getKey()), Optional.of(entry.getValue()));
            samples.add(TimeseriesUtils.createSampleForIndexingStrings(this.context, resource));
        }
        return samples;
    }

    public static MetricType mapType(AttributeType type) {
        switch (type) {
            case COUNTER: {
                return MetricType.COUNTER;
            }
            case GAUGE: {
                return MetricType.GAUGE;
            }
            case STRING: {
                return null;
            }
        }
        return MetricType.GAUGE;
    }

    public TimeKeeper getTimeKeeper() {
        return this.timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.timeKeeper = timeKeeper;
    }
}

