/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.aggregation;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.netmgt.timeseries.integration.aggregation.StandardAggregationFunctions;

public class SampleAggregator {
    final Metric expectedMetric;
    final List<Sample> samples;
    final Aggregation aggregation;
    final Instant startTime;
    final Instant endTime;
    final Duration bucketSize;

    private SampleAggregator(Metric expectedMetric, List<Sample> samples, Aggregation aggregation, Instant startTime, Instant endTime, Duration bucketSize) {
        this.expectedMetric = Objects.requireNonNull(expectedMetric);
        this.samples = Objects.requireNonNull(samples);
        this.aggregation = Objects.requireNonNull(aggregation);
        this.startTime = Objects.requireNonNull(startTime);
        this.endTime = Objects.requireNonNull(endTime);
        this.bucketSize = Objects.requireNonNull(bucketSize);
    }

    public static SampleAggregatorBuilder builder() {
        return new SampleAggregatorBuilder();
    }

    public List<Sample> computeAggregatedSamples() {
        Optional<Sample> missmatchedSample = this.samples.stream().filter(s -> !this.expectedMetric.equals(s.getMetric())).findAny();
        if (missmatchedSample.isPresent()) {
            throw new IllegalArgumentException(String.format("Expected Metric %s but found %s", this.expectedMetric, missmatchedSample.get().getMetric()));
        }
        if (this.aggregation == Aggregation.NONE) {
            return this.samples;
        }
        HashMap<Instant, List<Sample>> buckets = new HashMap<Instant, List<Sample>>();
        for (Sample sample : this.samples) {
            List<Sample> bucket = this.getBucket(buckets, sample.getTime());
            bucket.add(sample);
        }
        for (long l = this.startTime.toEpochMilli(); l <= this.endTime.toEpochMilli(); l += this.bucketSize.toMillis()) {
            Instant currentInstant = Instant.ofEpochMilli(l);
            List<Sample> bucket = this.getBucket(buckets, currentInstant);
            if (!bucket.isEmpty()) continue;
            bucket.add((Sample)ImmutableSample.builder().metric(this.expectedMetric).time(currentInstant).value(Double.valueOf(Double.NaN)).build());
        }
        return buckets.entrySet().stream().map(entry -> this.aggregate((Instant)entry.getKey(), (List)entry.getValue())).sorted(Comparator.comparing(i -> i.getTime().toEpochMilli())).collect(Collectors.toList());
    }

    private Sample aggregate(Instant startOfBucket, List<Sample> samples) {
        if (samples == null || samples.isEmpty()) {
            return null;
        }
        List values = samples.stream().map(Sample::getValue).collect(Collectors.toList());
        Double value = this.getAggregation().apply(values);
        return ImmutableSample.builder().metric(this.expectedMetric).time(startOfBucket).value(value).build();
    }

    private Function<Collection<Double>, Double> getAggregation() {
        if (Aggregation.MIN == this.aggregation) {
            return StandardAggregationFunctions.MIN;
        }
        if (Aggregation.MAX == this.aggregation) {
            return StandardAggregationFunctions.MAX;
        }
        return StandardAggregationFunctions.AVERAGE;
    }

    private List<Sample> getBucket(Map<Instant, List<Sample>> buckets, Instant instant) {
        long offset = instant.toEpochMilli() - this.startTime.toEpochMilli();
        long startOfBucket = this.startTime.toEpochMilli() + offset / this.bucketSize.toMillis() * this.bucketSize.toMillis();
        return buckets.computeIfAbsent(Instant.ofEpochMilli(startOfBucket), inst -> new ArrayList());
    }

    public static class SampleAggregatorBuilder {
        private Metric expectedMetric;
        private List<Sample> samples;
        private Aggregation aggregation;
        private Instant startTime;
        private Instant endTime;
        private Duration bucketSize;

        SampleAggregatorBuilder() {
        }

        public SampleAggregatorBuilder expectedMetric(Metric expectedMetric) {
            this.expectedMetric = expectedMetric;
            return this;
        }

        public SampleAggregatorBuilder samples(List<Sample> samples) {
            this.samples = samples;
            return this;
        }

        public SampleAggregatorBuilder aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public SampleAggregatorBuilder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public SampleAggregatorBuilder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public SampleAggregatorBuilder bucketSize(Duration bucketSize) {
            this.bucketSize = bucketSize;
            return this;
        }

        public SampleAggregator build() {
            return new SampleAggregator(this.expectedMetric, this.samples, this.aggregation, this.startTime, this.endTime, this.bucketSize);
        }

        public String toString() {
            return "SampleAggregator.SampleAggregatorBuilder(expectedMetric=" + this.expectedMetric + ", samples=" + this.samples + ", aggregation=" + this.aggregation + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", bucketSize=" + this.bucketSize + ")";
        }
    }
}

