/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.support;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.netmgt.timeseries.integration.support.SearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaSearchableResourceMetadataCache
implements SearchableResourceMetadataCache,
RemovalListener<String, ResourceMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaSearchableResourceMetadataCache.class);
    private static final Joiner m_keyJoiner = Joiner.on((char)':');
    private final Cache<String, ResourceMetadata> cache;
    private final ConcurrentRadixTree<ResourceMetadata> radixTree = new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
    private final Meter metricReqs;
    private final Meter attributeReqs;
    private final Meter metricMisses;
    private final Meter attributeMisses;

    @Inject
    public GuavaSearchableResourceMetadataCache(final @Named(value="search.resourceMetadata.maxCacheEntries") long maxSize, @Named(value="timeseriesMetricRegistry") MetricRegistry registry) {
        LOG.info("Initializing resource metadata cache ({} max entries)", (Object)maxSize);
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).removalListener((RemovalListener)this).build();
        this.metricReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-reqs"}));
        this.metricMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-misses"}));
        this.attributeReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-reqs"}));
        this.attributeMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-misses"}));
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return GuavaSearchableResourceMetadataCache.this.cache.size();
            }
        });
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"max-size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return maxSize;
            }
        });
    }

    public Optional<ResourceMetadata> get(Context context, Resource resource) {
        ResourceMetadata r = (ResourceMetadata)this.cache.getIfPresent((Object)this.key(context, resource.getId()));
        return r != null ? Optional.of((Object)r) : Optional.absent();
    }

    public void delete(Context context, Resource resource) {
        this.cache.invalidate((Object)this.key(context, resource.getId()));
    }

    private String key(Context context, String resourceId) {
        return m_keyJoiner.join((Object)context.getId(), (Object)resourceId, new Object[0]);
    }

    private String resourceId(Context context, String key) {
        return key.substring(context.getId().length() + 1);
    }

    public void merge(Context context, Resource resource, ResourceMetadata metadata) {
        Optional<ResourceMetadata> o = this.get(context, resource);
        if (!o.isPresent()) {
            ResourceMetadata newMetadata = new ResourceMetadata(this.metricReqs, this.attributeReqs, this.metricMisses, this.attributeMisses);
            newMetadata.merge(metadata);
            String key = this.key(context, resource.getId());
            this.cache.put((Object)key, (Object)newMetadata);
            this.radixTree.put((CharSequence)key, (Object)newMetadata);
            return;
        }
        ((ResourceMetadata)o.get()).merge(metadata);
    }

    @Override
    public List<String> getResourceIdsWithPrefix(Context context, String resourceIdPrefix) {
        return StreamSupport.stream(this.radixTree.getKeysStartingWith((CharSequence)this.key(context, resourceIdPrefix)).spliterator(), false).map(cs -> this.resourceId(context, cs.toString())).collect(Collectors.toList());
    }

    public void onRemoval(RemovalNotification<String, ResourceMetadata> notification) {
        this.radixTree.remove((CharSequence)notification.getKey());
    }

    public long getSize() {
        return this.cache.size();
    }
}

