/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.persistence;

import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.persistence.TimeseriesPersistOperationBuilder;
import org.opennms.newts.api.Context;

public class TimeseriesPersister
extends AbstractPersister {
    private final RrdRepository repository;
    private final TimeseriesWriter writer;
    private final Context context;
    private TimeseriesPersistOperationBuilder builder;

    protected TimeseriesPersister(ServiceParameters params, RrdRepository repository, TimeseriesWriter timeseriesWriter, Context context) {
        super(params, repository);
        this.repository = repository;
        this.writer = timeseriesWriter;
        this.context = context;
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            CollectionResource resource = group.getResource();
            this.builder = new TimeseriesPersistOperationBuilder(this.writer, this.context, this.repository, (ResourceIdentifier)resource, group.getName());
            if (resource.getTimeKeeper() != null) {
                this.builder.setTimeKeeper(resource.getTimeKeeper());
            }
            this.setBuilder(this.builder);
        }
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) throws PersistException {
        this.builder.persistStringAttribute(path, key, value);
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

