/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.dao;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.timeseries.impl.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.integration.dao.SearchResults;
import org.opennms.netmgt.timeseries.integration.support.TimeseriesUtils;
import org.opennms.netmgt.timeseries.meta.TimeSeriesMetaDataDao;
import org.opennms.newts.api.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesSearcher.class);
    @Autowired
    private TimeseriesStorageManager timeseriesStorageManager;
    @Autowired
    private TimeSeriesMetaDataDao metaDataDao;

    public Map<String, String> getResourceAttributes(ResourcePath path) {
        try {
            return this.metaDataDao.getForResourcePath(path);
        }
        catch (StorageException e) {
            LOG.warn("can not retrieve meta data for path: {}", (Object)path, (Object)e);
            return new HashMap<String, String>();
        }
    }

    public SearchResults search(ResourcePath path, int depth, boolean fetchMetrics) throws StorageException {
        int idxSuffix = path.elements().length - 1;
        int targetLen = idxSuffix + depth + 2;
        String key = "_idx" + idxSuffix;
        String value = String.format("(%s,%d)", TimeseriesUtils.toResourceId(path), targetLen);
        ImmutableTag indexTag = new ImmutableTag(key, value);
        List metrics = this.timeseriesStorageManager.get().getMetrics(Collections.singletonList(indexTag));
        HashMap<String, SearchResults.Result> resultPerResources = new HashMap<String, SearchResults.Result>();
        for (Metric metric : metrics) {
            String resourceId = metric.getFirstTagByKey("resourceId").getValue();
            SearchResults.Result result = (SearchResults.Result)resultPerResources.get(resourceId);
            if (result == null) {
                HashMap attributes = new HashMap();
                metric.getMetaTags().forEach(entry -> attributes.put(entry.getKey(), entry.getValue()));
                Resource resource = new Resource(metric.getFirstTagByKey("resourceId").getValue(), Optional.of(attributes));
                result = new SearchResults.Result(resource, new ArrayList<String>());
                resultPerResources.put(resourceId, result);
            }
            result.getMetrics().add(metric.getFirstTagByKey("name").getValue());
        }
        SearchResults results = new SearchResults();
        resultPerResources.values().forEach(results::addResult);
        return results;
    }
}

