/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.dao;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.netmgt.timeseries.impl.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.integration.TimeseriesWriter;
import org.opennms.netmgt.timeseries.integration.dao.SearchResults;
import org.opennms.netmgt.timeseries.integration.dao.TimeseriesSearcher;
import org.opennms.netmgt.timeseries.integration.support.SearchableResourceMetadataCache;
import org.opennms.netmgt.timeseries.integration.support.TimeseriesUtils;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesResourceStorageDao
implements ResourceStorageDao {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesResourceStorageDao.class);
    @Autowired
    private TimeseriesStorageManager storageManager;
    @Autowired
    private Context context;
    @Autowired
    private TimeseriesSearcher searcher;
    @Autowired
    private TimeseriesWriter writer;
    @Autowired
    private SearchableResourceMetadataCache searchableCache;

    public boolean exists(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        if (this.hasCachedEntry(path, depth, depth)) {
            return true;
        }
        return this.searchFor(path, depth, false).size() > 0;
    }

    public boolean existsWithin(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        if (this.hasCachedEntry(path, 0, depth)) {
            return true;
        }
        return IntStream.rangeClosed(0, depth).anyMatch(i -> this.searchFor(path, i, false).size() > 0);
    }

    public Set<ResourcePath> children(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        TreeSet matches = Sets.newTreeSet();
        SearchResults results = this.searchFor(path, depth, false);
        for (SearchResults.Result result : results) {
            ResourcePath child = TimeseriesResourceStorageDao.toChildResourcePath(path, result.getResource().getId());
            if (child == null) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{result.getResource(), path, depth});
                continue;
            }
            matches.add(child);
        }
        return matches;
    }

    public boolean delete(ResourcePath path) {
        SearchResults results = this.searchFor(path, 0, true);
        if (results.isEmpty()) {
            return false;
        }
        for (SearchResults.Result result : results) {
            for (String metricName : result.getMetrics()) {
                ImmutableMetric metric = ImmutableMetric.builder().intrinsicTag("resourceId", result.getResource().getId()).intrinsicTag("name", metricName).build();
                try {
                    this.storageManager.get().delete((Metric)metric);
                }
                catch (StorageException e) {
                    LOG.error("Could not delete {}, will ignore problem and continue ", (Object)metric, (Object)e);
                }
            }
        }
        return true;
    }

    public Set<OnmsAttribute> getAttributes(ResourcePath path) {
        HashSet attributes = Sets.newHashSet();
        Future stringAttributes = ForkJoinPool.commonPool().submit(this.getResourceAttributesCallable(path));
        SearchResults results = this.searchFor(path, 0, true);
        for (SearchResults.Result result : results) {
            String resourceId = result.getResource().getId();
            ResourcePath resultPath = TimeseriesUtils.toResourcePath(resourceId);
            if (!path.equals((Object)resultPath) && !Arrays.stream(path.elements()).map(String::trim).collect(Collectors.toList()).equals(Arrays.asList(resultPath.elements()))) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{result.getResource(), path, 0});
                continue;
            }
            if (ResourceTypeUtils.isResponseTime((String)resourceId)) {
                attributes.add(new RrdGraphAttribute(TimeseriesUtils.toMetricName(resourceId), "", resourceId));
                continue;
            }
            for (String metric : result.getMetrics()) {
                attributes.add(new RrdGraphAttribute(metric, "", resourceId));
            }
        }
        try {
            ((Map)stringAttributes.get()).entrySet().stream().map(e -> new StringPropertyAttribute((String)e.getKey(), (String)e.getValue())).forEach(attributes::add);
        }
        catch (InterruptedException | ExecutionException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
        return attributes;
    }

    public void setStringAttribute(ResourcePath path, String key, String value) {
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)key, (Object)value).build();
        Resource resource = new Resource(TimeseriesUtils.toResourceId(path), Optional.of((Object)attributes));
        Sample sample = TimeseriesUtils.createSampleForIndexingStrings(this.context, resource);
        this.writer.index(Lists.newArrayList((Object[])new Sample[]{sample}));
    }

    public String getStringAttribute(ResourcePath path, String key) {
        return this.getStringAttributes(path).get(key);
    }

    public Map<String, String> getStringAttributes(ResourcePath path) {
        return this.getMetaData(path);
    }

    public Map<String, String> getMetaData(ResourcePath path) {
        return this.searcher.getResourceAttributes(path);
    }

    private Callable<Map<String, String>> getResourceAttributesCallable(final ResourcePath path) {
        return new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() {
                return TimeseriesResourceStorageDao.this.searcher.getResourceAttributes(path);
            }
        };
    }

    public void updateMetricToResourceMappings(ResourcePath path, Map<String, String> metricsNameToResourceNames) {
    }

    private boolean hasCachedEntry(ResourcePath path, int minDepth, int maxDepth) {
        List<String> cachedResourceIds = this.searchableCache.getResourceIdsWithPrefix(this.context, TimeseriesUtils.toResourceId(path));
        for (String resourceId : cachedResourceIds) {
            int relativeDepth = path.relativeDepth(TimeseriesUtils.toResourcePath(resourceId));
            if (relativeDepth < minDepth || relativeDepth > maxDepth) continue;
            return true;
        }
        return false;
    }

    private SearchResults searchFor(ResourcePath path, int depth, boolean fetchMetrics) {
        SearchResults results;
        try {
            results = this.searcher.search(path, depth, fetchMetrics);
            LOG.trace("Found {} results.", (Object)results.size());
        }
        catch (StorageException e) {
            LOG.error("An error occured while querying for {}", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
        return results;
    }

    protected static ResourcePath toChildResourcePath(ResourcePath parent, String resourceId) {
        String[] parentEls;
        ResourcePath child = TimeseriesUtils.toResourcePath(resourceId);
        String[] childEls = child.elements();
        if (childEls.length <= (parentEls = parent.elements()).length) {
            return null;
        }
        String[] els = new String[parentEls.length + 1];
        for (int i = 0; i <= parentEls.length; ++i) {
            els[i] = childEls[i];
        }
        return ResourcePath.get((String[])els);
    }

    public void setSearchableCache(SearchableResourceMetadataCache searchableCache) {
        this.searchableCache = searchableCache;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setWriter(TimeseriesWriter writer) {
        this.writer = writer;
    }

    public void setSearcher(TimeseriesSearcher searcher) {
        this.searcher = searcher;
    }
}

