/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.integration.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opennms.newts.api.Resource;

public class SearchResults
implements Iterable<Result> {
    private final List<Result> results = Lists.newArrayList();

    public void addResult(Resource resource, Collection<String> metrics) {
        this.results.add(new Result(resource, metrics));
    }

    public void addResult(Result result) {
        this.results.add(result);
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public Iterator<Result> iterator() {
        return this.results.iterator();
    }

    public static class Result {
        private final Resource resource;
        private final Collection<String> metrics;

        Result(Resource resource, Collection<String> metrics) {
            this.resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
            this.metrics = (Collection)Preconditions.checkNotNull(metrics, (Object)"metrics argument");
        }

        public Resource getResource() {
            return this.resource;
        }

        public Collection<String> getMetrics() {
            return this.metrics;
        }
    }
}

